/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.parser;

import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.conf.ConfigureEntry;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.conf.NodeAttrSection;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.conf.NodeSection;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.func.JxpFunc;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.parser.ParamParser;
import com.irdstudio.allinflow.executor.application.executor.core.assembly.jxp.util.LogUtil;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.util.vo.VariableValue;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreParser {
    private static final Logger logger = LoggerFactory.getLogger(CoreParser.class);
    private ConfigureEntry cxd = null;
    private VariableValue vv = null;
    private JxpFunc func = null;
    private OutputStreamWriter file = null;
    private static final char SIGN_GT = '>';
    private static final char SIGN_LT = '<';

    public CoreParser(ConfigureEntry cxd, VariableValue vv) {
        this.cxd = cxd;
        this.vv = vv;
        this.func = new JxpFunc(cxd.getDefineSection());
    }

    public CoreParser(ConfigureEntry cxd, VariableValue vv, OutputStreamWriter osw) {
        this.cxd = cxd;
        this.vv = vv;
        this.file = osw;
        this.func = new JxpFunc(cxd.getDefineSection());
    }

    public CoreParser() {
    }

    public void linkConfigureEntry(ConfigureEntry cxd) {
        this.cxd = cxd;
        if (this.func == null) {
            this.func = new JxpFunc(cxd.getDefineSection());
        }
    }

    public void linkVariableValue(VariableValue vv) {
        this.vv = vv;
    }

    public void linkFileObject(OutputStreamWriter osw) {
        this.file = osw;
    }

    public boolean run() {
        if (this.cxd == null) {
            LogUtil.out("\u672a\u6302\u8f7dxml\u63cf\u8ff0\u5bf9\u8c61!");
            return false;
        }
        if (this.vv == null) {
            LogUtil.out("\u672a\u6302\u8f7d\u53d8\u91cf\u503c\u5bf9\u8c61");
            return false;
        }
        if (this.file == null) {
            LogUtil.out("\u672a\u6302\u8f7d\u5199\u6587\u4ef6\u5bf9\u8c61");
            return false;
        }
        try {
            this.generateXml(this.cxd.getNodeSection(), null);
            this.file.flush();
            LogUtil.out("");
        }
        catch (IOException e) {
            LogUtil.out("\u5199\u5165\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef!");
            LogUtil.writeError(e);
            return false;
        }
        catch (SQLException e) {
            LogUtil.out("\u89e3\u91ca\u8282\u70b9\u65f6\u9047\u5230SQL\u9519\u8bef!");
            LogUtil.writeError(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateXml(NodeSection nd, ResultSet rs) throws SQLException, IOException {
        Connection conn;
        block50: {
            ResultSet curRs = null;
            conn = null;
            try {
                if (nd.getType() == 1) {
                    if (!"".equals(nd.getLabelName())) {
                        this.file.write(60);
                        this.file.write(nd.getLabelName());
                        if (nd.getAttrs().size() > 0) {
                            this.generateAttrs(nd.getAttrs(), rs);
                        }
                        this.file.write(62);
                    }
                    this.outFormatLog(nd.getLabelName());
                    if (!"".equals(nd.getDataSrc())) {
                        conn = TConnPool.getDefaultPool().getConnection();
                        try (Statement st = conn.createStatement();){
                            String sql = ParamParser.parseVariable(nd.getDataSrc(), this.vv, rs);
                            curRs = st.executeQuery(sql);
                            if (!curRs.next()) {
                                curRs.close();
                                curRs = null;
                            }
                        }
                    }
                    if (!"".equals(nd.getField()) || !"".equals(nd.getFunc())) {
                        if (!"".equals(nd.getDataSrc())) {
                            if (curRs != null) {
                                this.file.write(this.getValue(nd, curRs));
                            }
                        } else if (rs != null) {
                            this.file.write(this.getValue(nd, rs));
                        }
                    }
                    if (nd.getNext().size() > 0) {
                        List<Object> nextList = nd.getNext();
                        for (int i = 0; i < nextList.size(); ++i) {
                            NodeSection subNode = (NodeSection)nextList.get(i);
                            this.generateXml(subNode, curRs);
                        }
                    }
                    if (!"".equals(nd.getLabelName())) {
                        this.file.write(60);
                        this.file.write(47);
                        this.file.write(nd.getLabelName());
                        this.file.write(62);
                        this.file.write(10);
                    }
                } else if (nd.getType() == 2) {
                    conn = TConnPool.getDefaultPool().getConnection();
                    try (Statement st = conn.createStatement();){
                        String sql = ParamParser.parseVariable(nd.getDataSrc(), this.vv, rs);
                        System.err.println(sql);
                        curRs = st.executeQuery(sql);
                        while (curRs.next()) {
                            if (!"".equals(nd.getLabelName())) {
                                this.file.write(60);
                                this.file.write(nd.getLabelName());
                                if (nd.getAttrs().size() > 0) {
                                    this.generateAttrs(nd.getAttrs(), curRs);
                                }
                                this.file.write(62);
                            }
                            this.outFormatLog(nd.getLabelName());
                            if (!"".equals(nd.getField())) {
                                this.file.write(this.getValue(nd, curRs));
                            }
                            if (nd.getNext().size() > 0) {
                                List<Object> nextList = nd.getNext();
                                for (int i = 0; i < nextList.size(); ++i) {
                                    NodeSection subNode = (NodeSection)nextList.get(i);
                                    this.generateXml(subNode, curRs);
                                }
                            }
                            if ("".equals(nd.getLabelName())) continue;
                            this.file.write(60);
                            this.file.write(47);
                            this.file.write(nd.getLabelName());
                            this.file.write(62);
                            this.file.write(10);
                        }
                    }
                }
                if (curRs == null) break block50;
            }
            catch (Throwable throwable) {
                if (curRs != null) {
                    curRs.close();
                }
                TConnPool.getDefaultPool().releaseConnection(conn);
                throw throwable;
            }
            curRs.close();
        }
        TConnPool.getDefaultPool().releaseConnection(conn);
    }

    private String getValue(NodeSection nd, ResultSet rs) throws SQLException {
        String value = "";
        if (!"".equals(nd.getFunc())) {
            String param = "";
            if (!"".equals(nd.getParam())) {
                param = ParamParser.parseVariable(nd.getParam(), this.vv, rs);
            }
            value = this.func.callJxpFunc(nd.getFunc(), param);
        } else {
            value = rs.getString(nd.getField());
        }
        if (value == null) {
            value = "";
        }
        if (nd.getMaxLen() > 0) {
            value = value.length() < nd.getMaxLen() ? value.substring(0, nd.getMaxLen()) : value.substring(0);
        }
        return value;
    }

    private void generateAttrs(List<?> attrs, ResultSet rs) throws IOException {
        for (int x = 0; x < attrs.size(); ++x) {
            NodeAttrSection attr = (NodeAttrSection)attrs.get(x);
            this.file.write(" " + attr.getName() + "=\"");
            this.file.write(ParamParser.parseVariable(attr.getValue(), this.vv, rs) + "\"");
        }
    }

    private void outFormatLog(String lableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u751f\u6210<");
        sb.append(lableName);
        sb.append(">\u6807\u7b7e...");
        LogUtil.out(sb.toString());
    }
}

