/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchDataUtil;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchTaskThread;
import com.irdstudio.allinflow.executor.application.executor.core.dao.CpnConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowConfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.util.DataMoveUtil;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.util.TableMove;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.ConnectionUtil;
import com.irdstudio.framework.beans.core.util.MapBeanUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchRunEngine {
    private static final String BATCH_RUN = "run";
    private static final String BATCH_STOP = "stop";
    private static final String BATCH_RERUN = "rerun";
    private static final String BATCH_CONTINUE = "continue";
    private static final String BATCH_FAIL_TRY = "failtry";
    private String batchAction;
    private String batchId;
    private String batchSerialNo;
    private String envId;
    private Map<String, Object> param;

    public BatchRunEngine(String batchAction, String batchId) {
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
    }

    public BatchRunEngine(String batchSerialNo, String batchAction, String batchId) {
        this.batchSerialNo = batchSerialNo;
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
    }

    public BatchRunEngine(String batchSerialNo, String batchAction, String batchId, String envId, Map<String, Object> param) {
        this.batchSerialNo = batchSerialNo;
        this.batchId = batchId;
        this.batchAction = batchAction.toLowerCase();
        this.envId = envId;
        this.param = param;
    }

    public void start() throws Exception {
        if (BATCH_RUN.equals(this.batchAction)) {
            this.doRunBatch();
        } else if (BATCH_STOP.equals(this.batchAction)) {
            this.doStopBatch();
        } else if (BATCH_RERUN.equals(this.batchAction)) {
            this.doRerunBatch();
        } else if (BATCH_CONTINUE.equals(this.batchAction)) {
            this.doContinueBatch();
        } else if (BATCH_FAIL_TRY.equals(this.batchAction)) {
            this.doTaskFailTry();
        }
    }

    private void doRunBatch() throws Exception {
        block14: {
            Connection conn = null;
            try {
                String genAlDesc;
                conn = TConnPool.getDefaultPool().getConnection();
                FlowConfMaster batchConfig = BatchDataUtil.getFlowConfMaster(conn, this.batchId);
                if (batchConfig == null) {
                    throw new Exception("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u3010" + this.batchId + "\u3011\u67e5\u8be2\u6d41\u7a0b\u4fe1\u606f\u914d\u7f6e\u8868\u3010flow_conf_master\u3011\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                    String cond = " where batch_id = '" + this.batchId + "'";
                    this.dataMove(conn, "flow_inst_master", "flow_hist_master", cond);
                    this.dataMove(conn, "flow_inst_node", "flow_hist_node", cond);
                    this.dataMove(conn, "plugin_inst_log", "plugin_hist_log", " where batch_sn like '" + this.batchId + "%'");
                }
                String condition1 = " where batch_id = '" + this.batchId + "'";
                TableMove batchDataMoveInst = DataMoveUtil.createTableMoveInst(conn, "flow_conf_master", "flow_inst_master");
                String no = "1";
                String batchSerialNo = this.batchSerialNo;
                String batchDate = CurrentDateUtil.getTodayDate();
                String alDesc = batchConfig.getBatchName();
                String startTime = CurrentDateUtil.getTodayDateEx2();
                batchDataMoveInst.addValueMapping("batch_serial_no", batchSerialNo);
                batchDataMoveInst.addValueMapping("subs_id", null);
                batchDataMoveInst.addValueMapping("subs_code", null);
                batchDataMoveInst.addValueMapping("batch_order", no);
                batchDataMoveInst.addValueMapping("batch_date", batchDate);
                batchDataMoveInst.addValueMapping("start_time", startTime);
                batchDataMoveInst.addValueMapping("batch_state", String.valueOf(8));
                batchDataMoveInst.addValueMapping("batch_intervene_state", String.valueOf(0));
                batchDataMoveInst.addValueMapping("module_code", batchConfig.getCbaCode());
                batchDataMoveInst.addValueMapping("env_id", this.envId);
                if (this.param != null) {
                    batchDataMoveInst.addValueMapping("app_id", MapUtils.getString(this.param, (Object)"appId"));
                    batchDataMoveInst.addValueMapping("app_code", MapUtils.getString(this.param, (Object)"appCode"));
                    batchDataMoveInst.addValueMapping("app_name", MapUtils.getString(this.param, (Object)"appName"));
                    batchDataMoveInst.addValueMapping("ext_param", MapUtils.getString(this.param, (Object)"extParam"));
                    batchDataMoveInst.addValueMapping("market_source", MapUtils.getString(this.param, (Object)"marketSource"));
                    batchDataMoveInst.addValueMapping("ecs_id", MapUtils.getString(this.param, (Object)"ecsId"));
                    batchDataMoveInst.addValueMapping("ecs_ip", MapUtils.getString(this.param, (Object)"ecsIp"));
                    batchDataMoveInst.addValueMapping("ecs_name", MapUtils.getString(this.param, (Object)"ecsName"));
                    String paramAlDesc = MapUtils.getString(this.param, (Object)"alDesc");
                    if (StringUtils.isNotBlank((CharSequence)paramAlDesc)) {
                        alDesc = paramAlDesc;
                    }
                    if (MapUtils.getString(this.param, (Object)"subsId") != null) {
                        batchDataMoveInst.addValueMapping("subs_id", MapUtils.getString(this.param, (Object)"subsId"));
                    }
                }
                HashMap<String, Object> genParam = new HashMap<String, Object>();
                genParam.put("batchSerialNo", batchSerialNo);
                genParam.put("subsId", null);
                genParam.put("batchOrder", no);
                genParam.put("batchDate", batchDate);
                genParam.put("startTime", startTime);
                genParam.put("batchInterveneState", String.valueOf(0));
                genParam.put("envId", this.envId);
                if (this.param != null) {
                    genParam.putAll(this.param);
                }
                if (StringUtils.isNotBlank((CharSequence)(genAlDesc = this.genAlDesc(batchConfig.getAlDescTemplate(), batchConfig, genParam)))) {
                    alDesc = genAlDesc;
                }
                batchDataMoveInst.addValueMapping("al_desc", alDesc);
                batchDataMoveInst.setCondition(condition1);
                batchDataMoveInst.executeCopy();
                FlowConfNodeDao taskConfigDao = new FlowConfNodeDao(conn);
                FlowConfNode startNode = taskConfigDao.queryStartByBatchId(this.batchId);
                FlowInstNode instNode = new FlowInstNode();
                instNode.setBatchId(startNode.getBatchId());
                instNode.setBatchOrder(Integer.parseInt(no));
                instNode.setBatchDate(batchDate);
                instNode.setTaskId(startNode.getTaskId());
                instNode.setTaskName(startNode.getTaskName());
                instNode.setStageId(startNode.getPluginId());
                instNode.setStageName(batchConfig.getBatchName() + "\u3010\u5f00\u59cb\u3011");
                instNode.setTaskRunState(String.valueOf(6));
                instNode.setTaskInterveneState(String.valueOf(0));
                instNode.setBatchSerialNo(batchSerialNo);
                instNode.setStartTime(startTime);
                instNode.setEndTime(startTime);
                instNode.setCostTime(BigDecimal.ZERO);
                FlowInstNodeDao instTaskDao = new FlowInstNodeDao(conn);
                int n = instTaskDao.insertInst(instNode);
                if (n > 0) {
                    FlowConfNode startNextNode = taskConfigDao.queryWithKeys(startNode.getNextTaskId());
                    instNode.setTaskId(startNextNode.getTaskId());
                    instNode.setTaskName(startNextNode.getTaskName());
                    instNode.setStageId(startNextNode.getPluginId());
                    CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(conn);
                    CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(startNextNode.getPluginId());
                    instNode.setStageName(confMaster.getCpnName());
                    instNode.setEndTime(null);
                    instNode.setTaskRunState(String.valueOf(1));
                    n = instTaskDao.insertInst(instNode);
                    if (n > 0) {
                        BatchRunProcess batRunProcess = new BatchRunProcess(batchSerialNo, batchConfig);
                        batRunProcess.start();
                        break block14;
                    }
                    throw new RuntimeException("\u521b\u5efa\u5f00\u59cb\u8282\u70b9\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5f02\u5e38");
                }
                throw new RuntimeException("\u521b\u5efa\u5f00\u59cb\u8282\u70b9\u5f02\u5e38");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
    }

    private String genAlDesc(String alDescTemplate, FlowConfMaster batchConfig, Map<String, Object> param) {
        if (StringUtils.isBlank((CharSequence)alDescTemplate)) {
            return null;
        }
        try {
            Map root = MapBeanUtil.beanToMap((Object)batchConfig);
            root.putAll(param);
            String extParam = MapUtils.getString(param, (Object)"extParam");
            try {
                Map extParamMap = (Map)JSON.parseObject((String)extParam, Map.class);
                root.put("extParam", extParamMap);
            }
            catch (Exception extParamMap) {
                // empty catch block
            }
            String alDesc = ExpressionUtil.parse(alDescTemplate, root);
            return alDesc;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void doStopBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            FlowConfMaster flowConfMaster = BatchDataUtil.getFlowConfMaster(conn, this.batchId);
            if (flowConfMaster == null) {
                throw new Exception("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u67e5\u8be2\u4e1a\u52a1\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            FlowInstNodeDao flowInstNodeDao = new FlowInstNodeDao(conn);
            String szCondition = "where batch_id = '" + this.batchId + "' and task_run_state = '2'";
            List<FlowInstNode> flowInstNodeList = flowInstNodeDao.queryWithCond(szCondition, "");
            if (flowInstNodeList.size() == 0) {
                throw new Exception("\u5f53\u524d\u4e1a\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff01");
            }
            for (FlowInstNode instTask : flowInstNodeList) {
                String batchSerialNo = instTask.getBatchSerialNo();
                String taskId = instTask.getTaskId();
                FlowConfNodeDao flowConfNodeDao = new FlowConfNodeDao(conn);
                String condition = " where previous_task_id = '" + taskId + "'";
                List<FlowConfNode> flowConfNodeList = flowConfNodeDao.queryWithCond(condition, "");
                if (flowConfNodeList.size() == 0) continue;
                Iterator<FlowConfNode> flowConfNodeIt = flowConfNodeList.iterator();
                while (flowConfNodeIt.hasNext()) {
                    String nextTaskId = flowConfNodeIt.next().getTaskId();
                    String condi = " set task_run_state = '7' where batch_id = '" + this.batchId + "' and task_id = '" + nextTaskId + "' and batch_serial_no = '" + batchSerialNo + "'";
                    flowInstNodeDao.updateFlowInstNode(condi);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doRerunBatch() throws Exception {
        Connection conn = null;
        try {
            conn = ConnectionUtil.getConnection();
            FlowConfMaster batchConfig = BatchDataUtil.getFlowConfMaster(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u67e5\u8be2\u4e1a\u52a1\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            String isRunAgain = batchConfig.getIsRunAgain();
            if (StringUtils.isBlank((CharSequence)isRunAgain)) {
                throw new Exception("\u67e5\u8be2\u662f\u5426\u5141\u8bb8\u91cd\u8dd1\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if ("N".equals(isRunAgain)) {
                throw new Exception("\u8be5\u4e1a\u52a1\u6d41\u7a0b\u4e0d\u652f\u6301\u91cd\u8dd1\uff01");
            }
            FlowInstMaster batchInst = BatchDataUtil.getFlowInstMaster(conn, this.batchId);
            if (batchInst == null) {
                throw new Exception("\u672a\u627e\u5230\u91cd\u8dd1\u7684\u4e1a\u52a1\u6d41\u7a0b\uff01");
            }
            String batchState = batchInst.getBatchState();
            if ("3".equals(batchState) || "8".equals(batchState)) {
                throw new Exception("\u4e1a\u52a1\u6d41\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u91cd\u8dd1\uff01");
            }
            String cond = " where batch_id = '" + this.batchId + "'";
            this.dataMove(conn, "flow_inst_master", "flow_hist_master", cond);
            this.dataMove(conn, "flow_inst_node", "flow_hist_node", cond);
            String condi1 = " where batch_id = '" + this.batchId + "'";
            TableMove batchDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "flow_inst_master", "flow_inst_master");
            batchDataMoveUtil.setCondition(condi1);
            String batchSerialNo = batchInst.getBatchSerialNo();
            String lastTwoSerial = batchSerialNo.substring(batchSerialNo.length() - 1, batchSerialNo.length());
            lastTwoSerial = Integer.parseInt(lastTwoSerial) < 10 ? "0" + (Integer.parseInt(lastTwoSerial) + 1) : "" + (Integer.parseInt(lastTwoSerial) + 1);
            batchSerialNo = batchSerialNo.substring(0, batchSerialNo.length() - 2) + lastTwoSerial;
            batchDataMoveUtil.addValueMapping("batch_serial_no", batchSerialNo);
            batchDataMoveUtil.addValueMapping("batch_order", batchInst.getBatchOrder() + 1);
            batchDataMoveUtil.executeCopy();
            String condi = " where batch_id = '" + this.batchId + "' and task_use_state='0' and (task_use_area = '1' or task_use_area = '3') ";
            TableMove taskDataMoveUtil = DataMoveUtil.createTableMoveInst(conn, "flow_conf_node", "flow_inst_node");
            taskDataMoveUtil.setCondition(condi);
            taskDataMoveUtil.executeCopy();
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ConnectionUtil.releaseConnection(conn);
        }
    }

    private void doContinueBatch() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            FlowConfMaster batchConfig = BatchDataUtil.getFlowConfMaster(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u67e5\u8be2\u4e1a\u52a1\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                throw new Exception("\u4e1a\u52a1\u6d41\u7a0b\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            FlowInstNodeDao taskInstDao = new FlowInstNodeDao(conn);
            taskInstDao.resetFaildTask(this.batchId, this.batchSerialNo);
            BatchRunProcess batRunProcess = new BatchRunProcess(batchConfig);
            batRunProcess.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void doTaskFailTry() throws Exception {
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            FlowInstNodeDao flowInstNodeDao = new FlowInstNodeDao(conn);
            FlowConfMaster batchConfig = BatchDataUtil.getFlowConfMaster(conn, this.batchId);
            if (batchConfig == null) {
                throw new Exception("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u67e5\u8be2\u4e1a\u52a1\u6d41\u7a0b\u914d\u7f6e\u8868\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.batchSerialNo)) {
                throw new Exception("\u4e1a\u52a1\u6d41\u7a0b\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            FlowInstMaster flowInstMaster = BatchDataUtil.getFlowInstMasterByBatchSerialNo(conn, this.batchSerialNo);
            Map extParam = (Map)JSON.parseObject((String)MapUtils.getString(this.param, (Object)"extParam"), Map.class);
            String taskId = MapUtils.getString((Map)extParam, (Object)"taskId");
            String condition = " where batch_id = '" + this.batchId + "' and task_id = '" + taskId + "'";
            FlowConfNodeDao flowConfNodeDao = new FlowConfNodeDao(conn);
            List<FlowConfNode> flowConfNodeList = flowConfNodeDao.queryWithCond(condition, "");
            FlowConfNode taskConf = flowConfNodeList.get(0);
            FlowInstNode taskInst = new FlowInstNode();
            taskInst.setBatchSerialNo(this.batchSerialNo);
            taskInst.setBatchId(batchConfig.getBatchId());
            taskInst.setTaskId(taskConf.getTaskId());
            taskInst.setTaskName(taskConf.getTaskName());
            String condi = " set task_run_state = '2' where batch_id = '" + this.batchId + "' and task_id = '" + taskId + "' and batch_serial_no = '" + this.batchSerialNo + "'";
            flowInstNodeDao.updateFlowInstNode(condi);
            BatchRunProcess batRunProcess = new BatchRunProcess(this.batchSerialNo, batchConfig);
            BatchTaskThread taskThread = new BatchTaskThread(flowInstMaster, taskInst, taskConf, batRunProcess);
            taskThread.start();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public void dataMove(Connection conn, String srcTableName, String destTableName, String cond) throws SQLException {
        TableMove dataMoveInst = DataMoveUtil.createTableMoveInst(conn, srcTableName, destTableName);
        dataMoveInst.setCondition(cond);
        dataMoveInst.executeCut();
    }
}

