/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.irdstudio.allinflow.cpn.types.CpnCategoryEnum;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfSourceDTO;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BaseTaskThread;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchDataUtil;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchTaskThread;
import com.irdstudio.allinflow.executor.application.executor.core.dao.CpnConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.CpnConfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowConfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.CpnConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.thread.TThreadPools;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.Convert;
import com.irdstudio.allinflow.executor.types.ExecutorInstInfo;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BatchRunProcess
extends Thread {
    private static final String END = "end";
    private String batchId = "";
    private String batchSerialNo = "";
    private FlowConfMaster batchConfig = null;
    private FlowInstMaster batchInst = null;
    private FlowConfNode curRunFlowConfNode = null;
    private int runState = 8;
    private int equallyTaskAmount = 0;
    private Integer taskThreadAmount = 0;
    private Connection conn = null;
    private ILogger logger = null;
    private ExecutorService threadPool = null;
    private static final Object taskThreadAmountLock = new Object();
    private FlowConfSourceDTO flowConfSource;
    private final ConcurrentHashMap<String, Object> variablePool;

    public BatchRunProcess(FlowConfMaster batchConfig) {
        this.batchConfig = batchConfig;
        this.variablePool = new ConcurrentHashMap();
    }

    public BatchRunProcess(String batchSerialNo, FlowConfMaster batchConfig) {
        this.batchSerialNo = batchSerialNo;
        this.batchConfig = batchConfig;
        this.variablePool = new ConcurrentHashMap();
    }

    public void setVariable(String key, Object value) {
        this.variablePool.put(key, value);
    }

    public Object getVariable(String key) {
        return this.variablePool.get(key);
    }

    public Map<String, Object> getVariablePool() {
        return this.variablePool;
    }

    public void clearPool() {
        this.variablePool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FlowInstMasterDao batchInstDao = null;
        try {
            this.conn = TConnPool.getDefaultPool().getConnection();
            batchInstDao = new FlowInstMasterDao(this.conn);
            this.initializing();
            if (null == this.batchConfig) {
                this.batchConfig = BatchDataUtil.getFlowConfMaster(this.conn, this.batchId);
            } else {
                this.batchId = this.batchConfig.getBatchId();
            }
            this.batchInst = StringUtils.isNotBlank((CharSequence)this.batchSerialNo) ? BatchDataUtil.getFlowInstMasterByBatchSerialNo(this.conn, this.batchSerialNo) : BatchDataUtil.getFlowInstMaster(this.conn, this.batchId);
            if (this.batchInst == null) {
                throw new SQLException("\u672a\u8bfb\u53d6\u5230\u6d41\u7a0b\u5b9e\u4f8b:" + this.batchId);
            }
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + this.batchInst.getBatchSerialNo() + ".log";
            System.err.println(fullLogFileName);
            ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            fileLogger.setName(this.batchInst.getBatchSerialNo());
            TLogger.registerCategoryLogger(this.batchInst.getBatchSerialNo(), fileLogger);
            this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
            this.logger.info("[" + this.batchId + "]\u6d41\u7a0b\u5f00\u59cb...");
            this.threadPool = TThreadPools.getThreadPool(this.batchInst.getBatchSerialNo());
            this.equallyTaskAmount = this.batchConfig.getEquallyTaskAmount();
            if (this.equallyTaskAmount <= 1) {
                this.equallyTaskAmount = 2;
            }
            this.batchInst.setStartTime(CurrentDateUtil.getTodayDateEx2());
            FlowConfNodeDao taskConfigDao = new FlowConfNodeDao(this.conn);
            FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
            this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7:" + this.batchId + "\uff0c\u6d41\u6c34\u53f7\uff1a" + this.batchSerialNo);
            FlowInstNode flowInstNode = instTaskDao.queryByWtrunTask(this.batchId, this.batchSerialNo);
            if (flowInstNode == null) {
                throw new RuntimeException("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u3010" + this.batchId + "\u3011\u6d41\u6c34\u53f7\u3010" + this.batchSerialNo + "\u3011\u67e5\u8be2\u4e0d\u5230\u5f85\u6267\u884c\u7684\u5b9e\u4f8b");
            }
            this.curRunFlowConfNode = taskConfigDao.queryWithKeys(flowInstNode.getTaskId());
            if (this.curRunFlowConfNode == null) {
                throw new RuntimeException("\u6839\u636e\u4efb\u52a1ID\u3010" + flowInstNode.getTaskId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u4e1a\u52a1\u6d41\u7a0b\u8282\u70b9\u914d\u7f6e");
            }
            batchInstDao.updateStage(this.curRunFlowConfNode.getTaskId(), this.curRunFlowConfNode.getTaskName(), this.batchSerialNo);
            boolean exeFail = this.executePrdCpnTask(this.conn, flowInstNode, this.curRunFlowConfNode);
            if (exeFail) {
                throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ea7\u54c1\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage(), e);
            this.runState = 1;
            if (null != this.batchInst) {
                this.batchInst.setBatchState(String.valueOf(this.runState));
                this.batchInst.setRemark(e.getMessage());
                try {
                    if (batchInstDao != null) {
                        batchInstDao.updateBatchToEnd(this.batchInst);
                    }
                }
                catch (SQLException e1) {
                    this.logger.error("\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                }
            } else {
                this.logger.error("\u6d41\u7a0b\u8fd0\u884c\u5b9e\u4f8b\u4fe1\u606f  batchInst \u4e3a\u7a7a\u6307\u9488\uff0c\u65e0\u6cd5\u66f4\u65b0\u7ec4\u4ef6\u72b6\u6001");
            }
            this.showdownThreadPool();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePrdCpnTask(Connection conn, FlowInstNode taskInst, FlowConfNode taskConf) {
        if (CpnCategoryEnum.M.getCode().equals(taskConf.getPluginType())) {
            FlowInstNodeDao instTaskDao = new FlowInstNodeDao(conn);
            FlowInstMasterDao batchInstDao = new FlowInstMasterDao(conn);
            try {
                instTaskDao.updateTaskInterveneState(taskInst.getTaskId(), String.valueOf(2));
                if (null != this.curRunFlowConfNode) {
                    instTaskDao.updateTaskInterveneState(this.curRunFlowConfNode.getTaskId(), String.valueOf(2));
                }
                if (null != this.batchInst) {
                    this.batchInst.setBatchState(String.valueOf(2));
                    batchInstDao.updateBatchToEnd(this.batchInst);
                }
                this.showdownThreadPool();
            }
            catch (Exception e) {
                this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u4efb\u52a1\u66f4\u65b0\u4efb\u52a1\u5e72\u9884\u72b6\u6001\u4e3a\u6302\u8d77\u5f02\u5e38", e);
            }
            return false;
        }
        this.runState = this.getBatchRunStateWithTask(taskInst, taskConf);
        if (this.runState == 1) {
            this.logger.info("[" + this.batchSerialNo + "]\u72b6\u6001[" + taskInst.getTaskRunState() + "]\u4e0b\u4ea7\u54c1\u7ec4\u4ef6\u8fd0\u884c\u5931\u8d25...");
            return true;
        }
        Object object = taskThreadAmountLock;
        synchronized (object) {
            if (this.taskThreadAmount >= this.equallyTaskAmount) {
                this.logger.info("\u542f\u52a8\u4e00\u4e2a\u7ebf\u7a0b\u8fd0\u884c\u4ea7\u54c1\u7ec4\u4ef6\u65f6\uff0c\u8fbe\u5230\u6700\u5927\u7ebf\u7a0b --> taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                return false;
            }
            this.doTaskTheadCalc(1);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u4ea7\u54c1\u7ec4\u4ef6\u7ebf\u7a0b\u6570\uff1a" + this.taskThreadAmount);
            BatchTaskThread taskThread = new BatchTaskThread(this.batchInst, taskInst, taskConf, this);
            if (this.threadPool == null || this.threadPool.isTerminated()) {
                this.threadPool = TThreadPools.getThreadPool(this.batchInst.getBatchSerialNo());
            }
            this.threadPool.execute(taskThread);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
        }
        return false;
    }

    private int getBatchRunStateWithTask(FlowInstNode taskInst, FlowConfNode taskConf) {
        int batchState = this.runState;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if (7 == state) {
            int skipTactic = Convert.StrToInt(taskConf.getTaskSkipTactic(), 2);
            if (skipTactic != 0) {
                if (skipTactic == 1) {
                    int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState());
                    if (interveneState != 1) {
                        batchState = 1;
                    }
                } else {
                    batchState = 1;
                }
            }
        } else {
            batchState = 3;
        }
        return batchState;
    }

    private int getBatchRunStateWithTask(FlowInstNode taskInst, CpnConfNode taskConf) {
        int batchState = this.runState;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if (7 == state) {
            int skipTactic = Convert.StrToInt(taskConf.getNodeSkipTactic(), 2);
            if (skipTactic != 0) {
                if (skipTactic == 1) {
                    int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState());
                    if (interveneState != 1) {
                        batchState = 1;
                    }
                } else {
                    batchState = 1;
                }
            }
        } else {
            batchState = 3;
        }
        return batchState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTaskTheadCalc(int i) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.taskThreadAmount = this.taskThreadAmount + i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskTheadCalc(int i) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.taskThreadAmount = i;
        }
    }

    public FlowConfSourceDTO getFlowConfSource() {
        return this.flowConfSource;
    }

    public void initializing() {
        this.setVariable("flowId", "Flow-Process-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueBaseCpnTask(FlowInstNode taskInst, CpnConfNode taskConf) {
        block19: {
            FlowInstNodeDao instTaskDao = null;
            FlowInstMasterDao batchInstDao = null;
            try {
                if (this.conn.isClosed()) {
                    this.conn = TConnPool.getDefaultPool().getConnection();
                }
                batchInstDao = new FlowInstMasterDao(this.conn);
                String startTime = CurrentDateUtil.getTodayDateEx2();
                instTaskDao = new FlowInstNodeDao(this.conn);
                CpnConfNodeDao cpnConfNodeDao = new CpnConfNodeDao(this.conn);
                CpnConfNode nextNode = cpnConfNodeDao.queryWithKeys(taskConf.getNextNodeId());
                taskInst.setTaskId(nextNode.getNodeId());
                taskInst.setTaskName(nextNode.getNodeName());
                taskInst.setStageId(nextNode.getBaseCpnId());
                taskInst.setStartTime(startTime);
                taskInst.setEndTime(null);
                taskInst.setTaskRunState(String.valueOf(1));
                FlowInstNode prdTaskInst = null;
                FlowConfNode prdTaskConf = null;
                if (END.equals(nextNode.getBaseCpnId())) {
                    taskInst.setTaskRunState(String.valueOf(6));
                    taskInst.setEndTime(startTime);
                    taskInst.setCostTime(BigDecimal.ZERO);
                    taskInst.setTaskInterveneState(String.valueOf(0));
                    prdTaskInst = instTaskDao.queryByTaskId(this.batchId, taskInst.getBatchSerialNo(), taskInst.getOther());
                    FlowConfNodeDao flowConfNodeDao = new FlowConfNodeDao(this.conn);
                    prdTaskConf = flowConfNodeDao.queryWithKeys(prdTaskInst.getTaskId());
                    instTaskDao.updateTaskRunState(prdTaskInst.getTaskId(), String.valueOf(6));
                    taskInst.setStageName(prdTaskConf.getTaskName() + "\u3010\u7ed3\u675f\u3011");
                } else {
                    CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(this.conn);
                    CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(nextNode.getBaseCpnId());
                    taskInst.setStageName(confMaster.getCpnName());
                }
                int n = instTaskDao.insertInst(taskInst);
                if (n > 0) {
                    if (prdTaskInst != null) {
                        this.setTaskTheadCalc(0);
                        this.continuePrdCpnTask(prdTaskInst, prdTaskConf);
                    } else {
                        this.doFinishPrdCpnBaseTask(nextNode, taskInst);
                    }
                    break block19;
                }
                throw new RuntimeException("\u521b\u5efa\u57fa\u7840\u7ec4\u4ef6\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5f02\u5e38");
            }
            catch (Exception e) {
                this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u57fa\u7840\u7ec4\u4ef6\u4efb\u52a1\u5f02\u5e38", e);
                this.runState = 1;
                if (null != this.curRunFlowConfNode) {
                    try {
                        instTaskDao.updateTaskRunState(this.curRunFlowConfNode.getTaskId(), String.valueOf(7));
                    }
                    catch (SQLException e1) {
                        this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u57fa\u7840\u7ec4\u4ef6\u4efb\u52a1\uff0c\u66f4\u65b0\u7ec4\u4ef6\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                    }
                }
                if (null != this.batchInst) {
                    this.batchInst.setBatchState(String.valueOf(this.runState));
                    this.batchInst.setRemark(e.getMessage());
                    try {
                        if (batchInstDao != null) {
                            batchInstDao.updateBatchToEnd(this.batchInst);
                        }
                    }
                    catch (SQLException e1) {
                        this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\uff0c\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                    }
                } else {
                    this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\uff0c\u6d41\u7a0b\u8fd0\u884c\u5b9e\u4f8b\u4fe1\u606f  batchInst \u4e3a\u7a7a\u6307\u9488\uff0c\u65e0\u6cd5\u66f4\u65b0\u7ec4\u4ef6\u72b6\u6001");
                }
                this.showdownThreadPool();
            }
            finally {
                TConnPool.getDefaultPool().releaseConnection(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinishPrdCpnBaseTask(CpnConfNode cpnConfNode, FlowInstNode instNode) throws SQLException {
        FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
        FlowInstMasterDao batchInstDao = new FlowInstMasterDao(this.conn);
        try {
            if (this.conn.isClosed()) {
                this.conn = TConnPool.getDefaultPool().getConnection();
            }
            this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7:" + this.batchId + "\uff0c\u6d41\u6c34\u53f7\uff1a" + this.batchSerialNo);
            Thread.sleep(10000L);
            String baseCpnId = cpnConfNode.getBaseCpnId();
            if (CpnCategoryEnum.M.getCode().equals(cpnConfNode.getBaseCpnType())) {
                instTaskDao.updateTaskInterveneState(instNode.getTaskId(), String.valueOf(2));
                if (null != this.curRunFlowConfNode) {
                    instTaskDao.updateTaskInterveneState(this.curRunFlowConfNode.getTaskId(), String.valueOf(2));
                }
                if (null != this.batchInst) {
                    this.batchInst.setBatchState(String.valueOf(2));
                    batchInstDao.updateBatchToEnd(this.batchInst);
                }
                this.showdownThreadPool();
                return;
            }
            if (END.equals(baseCpnId)) {
                instTaskDao.updateTaskRunState(instNode.getTaskId(), String.valueOf(6));
            } else {
                boolean exeFail = this.executeBaseCpnTask(instNode, cpnConfNode);
                if (exeFail) {
                    throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage(), e);
            this.runState = 1;
            if (null != this.curRunFlowConfNode) {
                instTaskDao.updateTaskRunState(this.curRunFlowConfNode.getTaskId(), String.valueOf(7));
            }
            if (null != this.batchInst) {
                this.batchInst.setBatchState(String.valueOf(this.runState));
                this.batchInst.setRemark(e.getMessage());
                try {
                    batchInstDao.updateBatchToEnd(this.batchInst);
                }
                catch (SQLException e1) {
                    this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\uff0c\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                }
            } else {
                this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\uff0c\u6d41\u7a0b\u8fd0\u884c\u5b9e\u4f8b\u4fe1\u606f  batchInst \u4e3a\u7a7a\u6307\u9488\uff0c\u65e0\u6cd5\u66f4\u65b0\u7ec4\u4ef6\u72b6\u6001");
            }
            this.showdownThreadPool();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBaseCpnTask(FlowInstNode taskInst, CpnConfNode taskConf) {
        this.runState = this.getBatchRunStateWithTask(taskInst, taskConf);
        if (this.runState == 1) {
            this.logger.info("[" + this.batchSerialNo + "]\u72b6\u6001[" + taskInst.getTaskRunState() + "]\u4e0b\u57fa\u7840\u7ec4\u4ef6\u8fd0\u884c\u5931\u8d25...");
            return true;
        }
        Object object = taskThreadAmountLock;
        synchronized (object) {
            if (this.taskThreadAmount >= this.equallyTaskAmount) {
                this.logger.info("\u542f\u52a8\u4e00\u4e2a\u7ebf\u7a0b\u8fd0\u884c\u57fa\u7840\u7ec4\u4ef6\u65f6\uff0c\u8fbe\u5230\u6700\u5927\u7ebf\u7a0b --> taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                return false;
            }
            this.doTaskTheadCalc(1);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u57fa\u7840\u7ec4\u4ef6\u7ebf\u7a0b\u6570\uff1a" + this.taskThreadAmount);
            BaseTaskThread taskThread = new BaseTaskThread(this.batchInst, taskInst, taskConf, this);
            if (this.threadPool == null || this.threadPool.isTerminated()) {
                this.threadPool = TThreadPools.getThreadPool(this.batchInst.getBatchSerialNo());
            }
            this.threadPool.execute(taskThread);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continuePrdCpnTask(FlowInstNode taskInst, FlowConfNode taskConf) throws SQLException {
        block15: {
            FlowInstMasterDao batchInstDao = null;
            try {
                if (this.conn.isClosed()) {
                    this.conn = TConnPool.getDefaultPool().getConnection();
                }
                batchInstDao = new FlowInstMasterDao(this.conn);
                FlowConfNodeDao taskConfigDao = new FlowConfNodeDao(this.conn);
                this.curRunFlowConfNode = taskConfigDao.queryWithKeys(taskConf.getNextTaskId());
                taskInst.setTaskId(this.curRunFlowConfNode.getTaskId());
                taskInst.setTaskName(this.curRunFlowConfNode.getTaskName());
                taskInst.setStageId(this.curRunFlowConfNode.getPluginId());
                CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(this.conn);
                CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(this.curRunFlowConfNode.getPluginId());
                taskInst.setStageName(confMaster.getCpnName());
                taskInst.setEndTime(null);
                taskInst.setTaskRunState(String.valueOf(1));
                FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
                int n = instTaskDao.insertInst(taskInst);
                if (n > 0) {
                    batchInstDao.updateStage(this.curRunFlowConfNode.getTaskId(), this.curRunFlowConfNode.getTaskName(), this.batchSerialNo);
                    boolean exeFail = this.executePrdCpnTask(this.conn, taskInst, this.curRunFlowConfNode);
                    if (exeFail) {
                        throw new RuntimeException("\u4ea7\u54c1\u7ec4\u4ef6\u6267\u884c\u5931\u8d25");
                    }
                    break block15;
                }
                throw new RuntimeException("\u521b\u5efa\u4ea7\u54c1\u7ec4\u4ef6\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5f02\u5e38");
            }
            catch (Exception e) {
                this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea7\u54c1\u7ec4\u4ef6\u4efb\u52a1\u5f02\u5e38", e);
                if (null != this.batchInst) {
                    this.batchInst.setBatchState(String.valueOf(1));
                    this.batchInst.setRemark(e.getMessage());
                    try {
                        if (batchInstDao != null) {
                            batchInstDao.updateBatchToEnd(this.batchInst);
                        }
                    }
                    catch (SQLException e1) {
                        this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea7\u54c1\u7ec4\u4ef6\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                    }
                } else {
                    this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea7\u54c1\u7ec4\u4ef6\uff0c\u6d41\u7a0b\u8fd0\u884c\u5b9e\u4f8b\u4fe1\u606f  batchInst \u4e3a\u7a7a\u6307\u9488\uff0c\u65e0\u6cd5\u66f4\u65b0\u7ec4\u4ef6\u72b6\u6001");
                }
                this.showdownThreadPool();
            }
            finally {
                if (END.equals(this.curRunFlowConfNode.getPluginId())) {
                    FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
                    instTaskDao.updateTaskRunState(this.curRunFlowConfNode.getTaskId(), String.valueOf(6));
                    if (null != this.batchInst) {
                        this.batchInst.setBatchState(String.valueOf(9));
                        batchInstDao.updateBatchToEnd(this.batchInst);
                    }
                    this.showdownThreadPool();
                    this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7ed3\u675f..." + Thread.currentThread().getName());
                }
                TConnPool.getDefaultPool().releaseConnection(this.conn);
            }
        }
    }

    private void showdownThreadPool() {
        if (this.batchInst != null) {
            TThreadPools.showdownThreadPool(this.batchInst.getBatchSerialNo());
        }
    }
}

