/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.dao;

import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.PubDbmsDatatype;
import com.irdstudio.allinflow.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubDbmsDatatypeDao {
    private static final Logger logger = LoggerFactory.getLogger(PubDbmsDatatypeDao.class);
    Connection conn = null;

    public PubDbmsDatatypeDao(Connection conn) {
        this.conn = conn;
    }

    public List<PubDbmsDatatype> queryPubDbmsDatatypeList(final PubDbmsDatatype paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.pub_dbms_datatype");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PubDbmsDatatype> list = new ArrayList<PubDbmsDatatype>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PubDbmsDatatype bean = (PubDbmsDatatype)((Object)POJOUtils.generatePOJO((ResultSet)rs, PubDbmsDatatype.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPubDbmsDatatypeList is wrong", e);
        }
        return list;
    }

    public List<PubDbmsDatatype> queryDbmsTypeByAppId(final String appId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.pub_dbms_datatype");
                this.WHERE("DBMS_ID = ( select biz_db_dbms from `allinflow_db`.paas_apps_info where app_id = ?)");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PubDbmsDatatype> list = new ArrayList<PubDbmsDatatype>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PubDbmsDatatype bean = (PubDbmsDatatype)((Object)POJOUtils.generatePOJO((ResultSet)rs, PubDbmsDatatype.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List<PubDbmsDatatype> queryDbmsTypeBySysCode(final String subsId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.pub_dbms_datatype");
                this.WHERE("DBMS_ID in ( select biz_db_dbms from `allinflow_db`.paas_apps_info where app_id in ( select app_id from `allinflow_db`.paas_apps_info where subs_id = ? ))");
                param.add(subsId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PubDbmsDatatype> list = new ArrayList<PubDbmsDatatype>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PubDbmsDatatype bean = (PubDbmsDatatype)((Object)POJOUtils.generatePOJO((ResultSet)rs, PubDbmsDatatype.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

