/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin;

import com.irdstudio.allinflow.cpn.types.CpnCategoryEnum;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginLogService;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.FlowConfVariable;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.FlowConfVariableDao;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PluginConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PluginConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.impl.ConnPoolForC3P0;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.DateCalculate;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.DateConvert;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.JvmUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.PathUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.vo.VariableValue;
import com.irdstudio.framework.beans.core.util.PropertiesUtil;
import com.irdstudio.framework.beans.core.util.RSAUtility;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PluginExecutor.class);
    private PluginContext ctx = null;
    BatchRunProcess batchRunProcess;
    private AbstractPlugin plugin = null;
    private PluginConfMaster pluginConfMaster = null;

    private PluginExecutor(PluginContext ctx, BatchRunProcess batchRunProcess) {
        this.ctx = ctx;
        this.batchRunProcess = batchRunProcess;
    }

    public static boolean callPlugin(PluginContext ctx, BatchRunProcess batchRunProcess) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        PluginExecutor executor = new PluginExecutor(ctx, batchRunProcess);
        if (executor.doInitialize()) {
            return executor.doExecute();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInitialize() {
        boolean flag = false;
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            PluginConfMasterDao pdDao = new PluginConfMasterDao(conn);
            this.pluginConfMaster = pdDao.queryWithKeys(this.ctx.getnPluginId());
            if (this.pluginConfMaster == null) {
                if (CpnCategoryEnum.CPN_CATETORY_PRODUCT.getCode().equals(this.ctx.getPluginType())) {
                    PluginConfMaster prdConfMaster = new PluginConfMaster();
                    prdConfMaster.setPluginId(this.ctx.getnPluginId());
                    prdConfMaster.setPluginName("\u4ea7\u54c1\u7ec4\u4ef6\u516c\u5171\u7236\u7c7b");
                    prdConfMaster.setPluginClass("com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PrdCpnPubPlugin");
                    prdConfMaster.setPluginType("1");
                    prdConfMaster.setPluginSource("A");
                    prdConfMaster.setNeedOtherDsVar("N");
                    this.pluginConfMaster = prdConfMaster;
                } else if (CpnCategoryEnum.R.getCode().equals(this.ctx.getPluginType())) {
                    // empty if block
                }
            }
            this.plugin = (AbstractPlugin)Class.forName(this.pluginConfMaster.getPluginClass()).newInstance();
            this.plugin.logService = PluginLogService.getInstance();
            this.ctx.setSzPluginName(this.pluginConfMaster.getPluginName());
            this.ctx.setVv(this.getSubsVariable(conn, this.ctx.getSzSubsCode()));
            if (this.ctx.getVv() == null) {
                this.plugin.writeFaildLog("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u7cfb\u7edf\u53d8\u91cf\u914d\u7f6e");
                boolean bl = false;
                return bl;
            }
            this.ctx.getVv().addVariable("PLUGIN_BIN_PATH", PathUtil.getClassRootPath());
            this.bindDataSourceToPluginContext();
            this.plugin.setPluginContext(this.ctx, this.batchRunProcess);
            flag = true;
        }
        catch (SQLException e) {
            this.ctx.setSzLastErrorMsg(e.getMessage());
            logger.error("\u521d\u59cb\u5316\u5e94\u7528\u63d2\u4ef6\u6267\u884c\u8005\u6570\u636e\u5e93\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.ctx.setSzLastErrorMsg(e.getMessage());
            logger.error("\u521d\u59cb\u5316\u5e94\u7528\u63d2\u4ef6\u6267\u884c\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return flag;
    }

    private void bindDataSourceToPluginContext() throws SQLException {
        if (this.ctx.getSzSubsDsCode() == null || "".equals(this.ctx.getSzSubsDsCode())) {
            this.ctx.setConnPool(TConnPool.getDefaultPool());
            return;
        }
        IConnPool connPool = TConnPool.getPoolInst(this.ctx.getSzSubsDsCode());
        if (connPool == null) {
            if (this.ctx.getDataSourceInfo() == null) {
                throw new SQLException("\u6ca1\u6709\u627e\u5230\u6267\u884c\u5e94\u7528\u63d2\u4ef6\u6240\u9700\u8981\u7684\u6570\u636e\u6e90!");
            }
            String user = this.ctx.getDataSourceInfo().getDsUserId();
            String password = this.ctx.getDataSourceInfo().getDsUserPwd();
            try {
                user = RSAUtility.decryptByBase64((String)user, (String)PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.privateKey"));
                password = RSAUtility.decryptByBase64((String)password, (String)PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.privateKey"));
            }
            catch (Exception e) {
                logger.info("RSA\u89e3\u5bc6\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u5bc6\u7801\u8fde\u63a5\u6570\u636e\u5e93\u3002" + e.getMessage());
            }
            if ("125".equals(this.ctx.getDataSourceInfo().getSubsDsType())) {
                connPool = new ConnPoolForC3P0(this.ctx.getDataSourceInfo().getDsConnStr(), user, password, "oracle.jdbc.driver.OracleDriver", 10, 2, 2, 20, 2);
                TConnPool.addConnInst(this.ctx.getSzSubsDsCode(), connPool);
            } else if ("725".equals(this.ctx.getDataSourceInfo().getSubsDsType())) {
                connPool = new ConnPoolForC3P0(this.ctx.getDataSourceInfo().getDsConnStr(), user, password, "sun.jdbc.odbc.JdbcOdbcDriver", 10, 2, 2, 20, 2);
                TConnPool.addConnInst(this.ctx.getSzSubsDsCode(), connPool);
            } else if ("425".equals(this.ctx.getDataSourceInfo().getSubsDsType())) {
                connPool = new ConnPoolForC3P0(this.ctx.getDataSourceInfo().getDsConnStr(), user, password, "com.mysql.jdbc.Driver", 10, 2, 2, 20, 2);
                TConnPool.addConnInst(this.ctx.getSzSubsDsCode(), connPool);
            }
        }
        this.ctx.setConnPool(connPool);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doExecute() {
        this.plugin.testVariable();
        this.plugin.logger.info("\u5f00\u59cb\u521d\u59cb\u5316...");
        this.plugin.logger.info("\u914d\u7f6e\u6765\u6e90\u65b9\u5f0f:" + this.ctx.getnPluginConfType() + ",\u914d\u7f6e\u6807\u8bc6:" + this.ctx.getSzPluginConfId() + ",\u4efb\u52a1\u7f16\u53f7:" + this.ctx.getSzTaskId() + "\uff0c\u4efb\u52a1\u540d\u79f0:" + this.ctx.getSzTaskName());
        if (this.ctx.getnPluginConfType() == 1) {
            if (!this.plugin.readPluginConfigureFromDB(this.ctx.getSzPluginConfId())) {
                this.plugin.writeFaildLog("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u914d\u7f6e", this.ctx.getSzLastErrorMsg());
                this.plugin.logger.info("\u5e94\u7528\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25!");
                return false;
            }
            this.plugin.writeSuccessLog("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u914d\u7f6e", "\u914d\u7f6e\u6807\u8bc6\u7b26:" + this.ctx.getSzPluginConfId());
        } else {
            if (!this.plugin.readPluginConfigureFromFile(this.ctx.getSzPluginConfId())) {
                this.plugin.writeFaildLog("\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u914d\u7f6e", this.ctx.getSzLastErrorMsg());
                this.plugin.logger.info("\u5e94\u7528\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25!");
                return false;
            }
            this.plugin.writeSuccessLog("\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u914d\u7f6e", "\u914d\u7f6e\u6587\u4ef6:" + this.ctx.getSzPluginConfId());
        }
        if (this.plugin.execute()) {
            this.plugin.writeSuccessLog("\u5e94\u7528\u63d2\u4ef6\u6267\u884c", "");
            StringBuffer info = new StringBuffer();
            info.append("\u6700\u5927\u8fde\u63a5\u6570\uff1a").append(TConnPool.getDefaultPool().getConnectionCount()).append(",");
            info.append(JvmUtil.getJvmMemoryWithM());
            this.plugin.logger.info(info);
            return true;
        }
        this.plugin.writeFaildLog("\u5e94\u7528 \u63d2\u4ef6\u6267\u884c", this.ctx.getSzLastErrorMsg());
        StringBuffer info = new StringBuffer();
        info.append("\u6700\u5927\u8fde\u63a5\u6570\uff1a").append(TConnPool.getDefaultPool().getConnectionCount()).append(",");
        info.append(JvmUtil.getJvmMemoryWithM());
        this.plugin.logger.info(info);
        return false;
    }

    private VariableValue getSubsVariable(Connection conn, String subsId) throws SQLException {
        VariableValue vv = null;
        try {
            vv = new VariableValue();
            SSubsInfoDao subsDao = new SSubsInfoDao(conn);
            SSubsInfo subsInfo = subsDao.querySSubsInfoWithKeys(subsId);
            if (subsInfo == null) {
                subsInfo = new SSubsInfo();
                subsInfo.setSubsCode(subsId);
                subsInfo.setSubsDataDate(CurrentDateUtil.getTodayDate());
            }
            vv.addVariable("subs_data_date", subsInfo.getSubsDataDate());
            if (subsInfo.getSubsDataDate() == null) {
                subsInfo.setSubsDataDate(CurrentDateUtil.getTodayDate());
            }
            vv.addVariable("subs_data_date_8", subsInfo.getSubsDataDate().replaceAll("-", ""));
            vv.addVariable("subs_last_data_date", subsInfo.getSubsLastDataDate());
            vv.addVariable("subs_next_data_date", DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(subsInfo.getSubsDataDate()), 1)));
            vv.addVariable("subs_load_date", subsInfo.getSubsLoadDate());
            vv.addVariable("subs_bat_date", subsInfo.getSubsBatDate());
            FlowConfVariableDao paramDao = new FlowConfVariableDao(conn);
            FlowConfVariable sParam = new FlowConfVariable();
            sParam.setTaskId(this.ctx.getSzTaskId());
            List<FlowConfVariable> paramList = paramDao.queryTaskParamList(sParam);
            for (int i = 0; i < paramList.size(); ++i) {
                FlowConfVariable param = paramList.get(i);
                if (!"1".equals(param.getParamScope()) && (!"2".equals(param.getParamScope()) || !subsId.equals(param.getSubsId())) && (!"3".equals(param.getParamScope()) || !this.pluginConfMaster.getPluginId().equals(param.getPluginId()))) continue;
                vv.addVariable(param.getParamCode().trim(), paramList.get(i).getParamValue().trim());
            }
            vv.addVariable("subs_code", subsId);
        }
        catch (SQLException e) {
            vv = null;
            throw e;
        }
        return vv;
    }
}

