/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin;

import com.irdstudio.allinflow.executor.annotation.plugin.PluginRegister;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PluginConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PluginConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.framework.beans.core.vo.DateDataVO;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;

@Component
public class PluginRegistrationHandler
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(PluginRegistrationHandler.class);
    private static final String PLUGIN_BASE_PACKAGE = "com.irdstudio.allinflow.executor.application.executor.core.plugin";

    public void run(ApplicationArguments args) throws Exception {
        List<Class<?>> pluginClasses = this.scanClassesWithAnnotation(PLUGIN_BASE_PACKAGE, PluginRegister.class);
        Connection conn = null;
        conn = TConnPool.getDefaultPool().getConnection();
        PluginConfMasterDao pluginConfMasterDao = new PluginConfMasterDao(conn);
        for (Class<?> clazz : pluginClasses) {
            PluginRegister annotation;
            if (clazz.isInterface() || clazz.isAnnotation() || (annotation = clazz.getAnnotation(PluginRegister.class)) == null) continue;
            logger.info("\u53d1\u73b0\u63d2\u4ef6: " + clazz.getName());
            PluginConfMaster pluginConfMaster = new PluginConfMaster();
            pluginConfMaster.setPluginId(annotation.pluginId());
            pluginConfMaster.setPluginName(annotation.pluginName());
            pluginConfMaster.setPluginClass(clazz.getName());
            pluginConfMaster.setPluginDesc(annotation.pluginDesc());
            pluginConfMaster.setPluginConfigUrl(annotation.pluginConfigUrl());
            pluginConfMaster.setPluginCatalog(annotation.pluginCatalog());
            pluginConfMaster.setPluginType(annotation.pluginType());
            pluginConfMaster.setPluginSource(annotation.pluginSource());
            pluginConfMaster.setNeedOtherDsVar(annotation.needOtherDsVar());
            PluginConfMaster existingPlugin = pluginConfMasterDao.queryWithKeys(annotation.pluginId());
            if (existingPlugin == null) {
                pluginConfMaster.setCreateTime(DateDataVO.getCurrentTime());
                pluginConfMaster.setLastModifyTime(DateDataVO.getCurrentTime());
                pluginConfMasterDao.insert(pluginConfMaster);
                logger.info("\u63d2\u4ef6\u5df2\u65b0\u589e: ID={}", (Object)annotation.pluginId());
                continue;
            }
            pluginConfMaster.setLastModifyTime(DateDataVO.getCurrentTime());
            pluginConfMasterDao.update(pluginConfMaster);
            logger.info("\u63d2\u4ef6\u5df2\u66f4\u65b0: ID={}", (Object)annotation.pluginId());
        }
        TConnPool.getDefaultPool().releaseConnection(conn);
    }

    private List<Class<?>> scanClassesWithAnnotation(String packageName, Class<?> annotationClass) throws Exception {
        ArrayList classes = new ArrayList();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        String packageSearchPath = "classpath*:" + packageName.replace('.', '/') + "/**/*.class";
        for (Resource resource : resolver.getResources(packageSearchPath)) {
            MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
            String className = reader.getClassMetadata().getClassName();
            Class<?> clazz = Class.forName(className);
            if (!clazz.isAnnotationPresent(annotationClass)) continue;
            classes.add(clazz);
        }
        return classes;
    }
}

