/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin.common;

import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.PluginConfMaster;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfMasterDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfMasterDao.class);
    Connection conn = null;

    public PluginConfMasterDao(Connection conn) {
        this.conn = conn;
    }

    public PluginConfMaster queryWithKeys(String pluginId) throws SQLException {
        PluginConfMaster pluginConfMaster = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_conf_master WHERE plugin_id=?");
            ps.setString(1, pluginId);
            rs = ps.executeQuery();
            if (rs.next()) {
                pluginConfMaster = (PluginConfMaster)POJOUtils.generatePOJO((ResultSet)rs, PluginConfMaster.class);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryWithKeys is Wrong! " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return pluginConfMaster;
    }

    public List<PluginConfMaster> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<PluginConfMaster> pluginList = new ArrayList<PluginConfMaster>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_conf_master " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginConfMaster plugin = (PluginConfMaster)POJOUtils.generatePOJO((ResultSet)rs, PluginConfMaster.class);
                pluginList.add(plugin);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryWithCond is Wrong! " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return pluginList;
    }

    public void insert(PluginConfMaster pluginConfMaster) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("INSERT INTO plugin_conf_master (plugin_id, plugin_name, plugin_class, plugin_desc, need_other_ds_var, plugin_config_url, plugin_catalog, plugin_type, plugin_source, create_user, create_time, last_modify_user, last_modify_time) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setString(1, pluginConfMaster.getPluginId());
            ps.setString(2, pluginConfMaster.getPluginName());
            ps.setString(3, pluginConfMaster.getPluginClass());
            ps.setString(4, pluginConfMaster.getPluginDesc());
            ps.setString(5, String.valueOf(pluginConfMaster.getNeedOtherDsVar()));
            ps.setString(6, pluginConfMaster.getPluginConfigUrl());
            ps.setString(7, pluginConfMaster.getPluginCatalog());
            ps.setString(8, pluginConfMaster.getPluginType());
            ps.setString(9, pluginConfMaster.getPluginSource());
            ps.setString(10, pluginConfMaster.getCreateUser());
            ps.setString(11, pluginConfMaster.getCreateTime());
            ps.setString(12, pluginConfMaster.getLastModifyUser());
            ps.setString(13, pluginConfMaster.getLastModifyTime());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new SQLException("insert is Wrong! " + e.getMessage());
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public void update(PluginConfMaster pluginConfMaster) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("UPDATE plugin_conf_master SET plugin_name=?, plugin_class=?, plugin_desc=?, need_other_ds_var=?, plugin_config_url=?, plugin_catalog=?, plugin_type=?, plugin_source=?, create_user=?, create_time=?, last_modify_user=?, last_modify_time=? WHERE plugin_id=?");
            ps.setString(1, pluginConfMaster.getPluginName());
            ps.setString(2, pluginConfMaster.getPluginClass());
            ps.setString(3, pluginConfMaster.getPluginDesc());
            ps.setString(4, String.valueOf(pluginConfMaster.getNeedOtherDsVar()));
            ps.setString(5, pluginConfMaster.getPluginConfigUrl());
            ps.setString(6, pluginConfMaster.getPluginCatalog());
            ps.setString(7, pluginConfMaster.getPluginType());
            ps.setString(8, pluginConfMaster.getPluginSource());
            ps.setString(9, pluginConfMaster.getCreateUser());
            ps.setString(10, pluginConfMaster.getCreateTime());
            ps.setString(11, pluginConfMaster.getLastModifyUser());
            ps.setString(12, pluginConfMaster.getLastModifyTime());
            ps.setString(13, pluginConfMaster.getPluginId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new SQLException("update is Wrong! " + e.getMessage());
        }
        finally {
            this.close(null, null, ps);
        }
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

