/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin.common;

import com.irdstudio.allinflow.executor.application.executor.core.dao.AbstractPageDao;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinflow.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSubsInfoDao
extends AbstractPageDao {
    private static final Logger logger = LoggerFactory.getLogger(SSubsInfoDao.class);
    Connection conn = null;

    public SSubsInfoDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public SSubsInfo querySSubsInfoWithKeys(String subsId) throws SQLException {
        SSubsInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM `allinflow_db`.s_subs_info WHERE subs_id=?");
            ps.setString(1, subsId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (SSubsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, SSubsInfo.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySSubsInfoWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public boolean insertSSubsInfo(final SSubsInfo vo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinflow_db`.s_subs_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)vo));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query insertSSubsInfo is wrong", e);
        }
        return false;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }

    public List<SSubsInfo> queryAllSubsInfoByPage(final SSubsInfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.*, (select cnname from s_dic where enname = t.arch_level_type and opttype = 'ARCH_LEVEL_TYPE') as archLevelType_name, (select cnname from s_dic where enname = t.subs_state and opttype = 'SUBS_STATE') as subsState_name, (select cnname from s_dic where enname = t.scope_use and opttype = 'SCOPE_USE') as scopeUse_name, (select cnname from s_dic where enname = t.service_used and opttype = 'SERVICE_USED') as serviceUsed_name ");
                this.FROM("`allinflow_db`.s_subs_info t");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SSubsInfo> list = new ArrayList<SSubsInfo>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsInfo bean = (SSubsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, SSubsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryAllSubsInfoByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }
}

