/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.tinycore.thread;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TThreadPools {
    private static ConcurrentMap<String, ExecutorService> threadPools = new ConcurrentHashMap<String, ExecutorService>();

    public static ExecutorService getThreadPool(String threadPoolName) {
        if (threadPools.get(threadPoolName) == null || ((ExecutorService)threadPools.get(threadPoolName)).isTerminated()) {
            TThreadPools.registerCachedThreadPool(threadPoolName);
        }
        return (ExecutorService)threadPools.get(threadPoolName);
    }

    private static void registerCachedThreadPool(String threadPoolName) {
        threadPools.put(threadPoolName, Executors.newCachedThreadPool());
    }

    public static void showdownThreadPool(String threadPoolName) {
        ExecutorService executorService = (ExecutorService)threadPools.get(threadPoolName);
        if (executorService != null) {
            executorService.shutdown();
            threadPools.remove(threadPoolName);
        }
    }

    public static ConcurrentMap<String, ExecutorService> getLocalStoreMap() {
        return threadPools;
    }
}

