/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.irdstudio.allinflow.console.types.BatchRunStateEnum;
import com.irdstudio.allinflow.cpn.types.TaskStateEnum;
import com.irdstudio.allinflow.deliver.console.facade.dto.FlowConfSourceDTO;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BaseTaskThread;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchDataUtil;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchTaskThread;
import com.irdstudio.allinflow.executor.application.executor.core.batch.CpnExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.batch.ExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.batch.FlowInstRunState;
import com.irdstudio.allinflow.executor.application.executor.core.batch.RootContext;
import com.irdstudio.allinflow.executor.application.executor.core.dao.CpnConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.CpnConfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowConfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.CpnConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.thread.TThreadPools;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.executor.types.ExecutorInstInfo;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BatchRunProcess
extends Thread {
    private static final String THREAD_POOL_NAME = "allinflow-exeutor";
    private static final String END = "end";
    private RootContext rootContext;
    private String batchId = "";
    private String batchSerialNo = "";
    private FlowConfMaster batchConfig = null;
    private FlowInstMaster batchInst = null;
    private FlowConfNode curRunFlowConfNode = null;
    private Connection conn = null;
    private ILogger logger = null;
    private ExecutorService threadPool = null;
    private static final Object taskThreadAmountLock = new Object();
    private FlowConfSourceDTO flowConfSource;
    private final ConcurrentHashMap<String, Object> variablePool;

    public BatchRunProcess(FlowConfMaster batchConfig) {
        this.batchConfig = batchConfig;
        this.variablePool = new ConcurrentHashMap();
        this.rootContext = new RootContext();
    }

    public BatchRunProcess(String batchSerialNo, FlowConfMaster batchConfig) {
        this.batchSerialNo = batchSerialNo;
        this.batchConfig = batchConfig;
        this.variablePool = new ConcurrentHashMap();
        this.rootContext = new RootContext();
    }

    public void setVariable(String key, Object value) {
        this.variablePool.put(key, value);
    }

    public Object getVariable(String key) {
        return this.variablePool.get(key);
    }

    public Map<String, Object> getVariablePool() {
        return this.variablePool;
    }

    public void clearPool() {
        this.variablePool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FlowInstMasterDao batchInstDao = null;
        try {
            this.conn = TConnPool.getDefaultPool().getConnection();
            batchInstDao = new FlowInstMasterDao(this.conn);
            this.initializing();
            if (null == this.batchConfig) {
                this.batchConfig = BatchDataUtil.getFlowConfMaster(this.conn, this.batchId);
            } else {
                this.batchId = this.batchConfig.getBatchId();
            }
            this.batchInst = StringUtils.isNotBlank((CharSequence)this.batchSerialNo) ? BatchDataUtil.getFlowInstMasterByBatchSerialNo(this.conn, this.batchSerialNo) : BatchDataUtil.getFlowInstMaster(this.conn, this.batchId);
            if (this.batchInst == null) {
                throw new SQLException("\u672a\u8bfb\u53d6\u5230\u6d41\u7a0b\u5b9e\u4f8b:" + this.batchId);
            }
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + this.batchInst.getBatchSerialNo() + ".log";
            System.err.println(fullLogFileName);
            ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            fileLogger.setName(this.batchInst.getBatchSerialNo());
            TLogger.registerCategoryLogger(this.batchInst.getBatchSerialNo(), fileLogger);
            this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
            this.logger.info("[" + this.batchId + "]\u6d41\u7a0b\u5f00\u59cb...");
            this.threadPool = TThreadPools.getThreadPool(THREAD_POOL_NAME);
            this.batchInst.setStartTime(CurrentDateUtil.getTodayDateEx2());
            FlowConfNodeDao taskConfigDao = new FlowConfNodeDao(this.conn);
            FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
            this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7:" + this.batchId + "\uff0c\u6d41\u6c34\u53f7\uff1a" + this.batchSerialNo);
            FlowInstNode flowInstNode = instTaskDao.queryByWtrunTask(this.batchId, this.batchSerialNo);
            if (flowInstNode == null) {
                throw new RuntimeException("\u6839\u636e\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7\u3010" + this.batchId + "\u3011\u6d41\u6c34\u53f7\u3010" + this.batchSerialNo + "\u3011\u67e5\u8be2\u4e0d\u5230\u5f85\u6267\u884c\u7684\u5b9e\u4f8b");
            }
            this.curRunFlowConfNode = taskConfigDao.queryWithKeys(flowInstNode.getTaskId());
            if (this.curRunFlowConfNode == null) {
                throw new RuntimeException("\u6839\u636e\u4efb\u52a1ID\u3010" + flowInstNode.getTaskId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u4e1a\u52a1\u6d41\u7a0b\u8282\u70b9\u914d\u7f6e");
            }
            this.rootContext.setBatchId(this.batchId);
            this.rootContext.setBatchSerialNo(this.batchSerialNo);
            this.rootContext.setVariablePool(this.variablePool);
            batchInstDao.updateStage(this.curRunFlowConfNode.getTaskId(), this.curRunFlowConfNode.getTaskName(), this.batchSerialNo);
            boolean exeFail = this.executePrdCpnTask(this.conn, flowInstNode, this.curRunFlowConfNode);
            if (exeFail) {
                throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ea7\u54c1\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage(), e);
            this.handleUpdateAllState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_EXCEPTION.getCode(), BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode(), e.getMessage());
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePrdCpnTask(Connection conn, FlowInstNode taskInst, FlowConfNode taskConf) {
        this.rootContext.setFlowConfNode(taskConf.getTaskId(), taskConf);
        this.rootContext.setFlowInstNode(taskInst.getTaskId(), taskInst);
        this.rootContext.setCurTaskId(taskInst.getTaskId());
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u4ea7\u54c1\u7ec4\u4ef6\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u5f53\u524d\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a" + this.getActiveCount());
            BatchTaskThread taskThread = new BatchTaskThread(this.batchInst, taskInst, taskConf, this);
            if (this.threadPool == null || this.threadPool.isTerminated()) {
                this.threadPool = TThreadPools.getThreadPool(THREAD_POOL_NAME);
            }
            this.threadPool.execute(taskThread);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
        }
        return false;
    }

    public FlowConfSourceDTO getFlowConfSource() {
        return this.flowConfSource;
    }

    public void initializing() {
        this.setVariable("flowId", "Flow-Process-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueBaseCpnTask(FlowInstNode taskInst, CpnConfNode taskConf) {
        block11: {
            FlowInstNodeDao instTaskDao = null;
            FlowInstMasterDao batchInstDao = null;
            try {
                if (this.conn.isClosed()) {
                    this.conn = TConnPool.getDefaultPool().getConnection();
                }
                batchInstDao = new FlowInstMasterDao(this.conn);
                String startTime = CurrentDateUtil.getTodayDateEx2();
                instTaskDao = new FlowInstNodeDao(this.conn);
                CpnConfNodeDao cpnConfNodeDao = new CpnConfNodeDao(this.conn);
                CpnConfNode nextNode = cpnConfNodeDao.queryWithKeys(taskConf.getNextNodeId());
                taskInst.setTaskId(nextNode.getNodeId());
                taskInst.setTaskName(nextNode.getNodeName());
                taskInst.setStageId(nextNode.getBaseCpnId());
                taskInst.setStartTime(startTime);
                taskInst.setEndTime(null);
                taskInst.setTaskRunState(TaskStateEnum.TASK_STATE_WTRUN.getCode());
                FlowInstNode prdTaskInst = null;
                FlowConfNode prdTaskConf = null;
                if (END.equals(nextNode.getBaseCpnId())) {
                    taskInst.setTaskRunState(TaskStateEnum.TASK_STATE_SUCCESS.getCode());
                    taskInst.setEndTime(startTime);
                    taskInst.setCostTime(BigDecimal.ZERO);
                    prdTaskInst = instTaskDao.queryByTaskId(this.batchId, taskInst.getBatchSerialNo(), taskInst.getOther());
                    FlowConfNodeDao flowConfNodeDao = new FlowConfNodeDao(this.conn);
                    prdTaskConf = flowConfNodeDao.queryWithKeys(prdTaskInst.getTaskId());
                    instTaskDao.updateTaskRunState(prdTaskInst.getTaskId(), TaskStateEnum.TASK_STATE_SUCCESS.getCode());
                    taskInst.setStageName(prdTaskConf.getTaskName() + "\u3010\u7ed3\u675f\u3011");
                } else {
                    CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(this.conn);
                    CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(nextNode.getBaseCpnId());
                    taskInst.setStageName(confMaster.getCpnName());
                }
                int n = instTaskDao.insertInst(taskInst);
                if (n > 0) {
                    if (prdTaskInst != null) {
                        this.continuePrdCpnTask(prdTaskInst, prdTaskConf);
                    } else {
                        this.doFinishPrdCpnBaseTask(nextNode, taskInst);
                    }
                    break block11;
                }
                throw new RuntimeException("\u521b\u5efa\u57fa\u7840\u7ec4\u4ef6\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5f02\u5e38");
            }
            catch (Exception e) {
                this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u57fa\u7840\u7ec4\u4ef6\u4efb\u52a1\u5f02\u5e38", e);
                this.handleUpdateAllState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_EXCEPTION.getCode(), BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode(), e.getMessage());
            }
            finally {
                TConnPool.getDefaultPool().releaseConnection(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinishPrdCpnBaseTask(CpnConfNode cpnConfNode, FlowInstNode instNode) throws SQLException {
        FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
        FlowInstMasterDao batchInstDao = new FlowInstMasterDao(this.conn);
        this.rootContext.setCpnConfNode(cpnConfNode.getNodeId(), cpnConfNode);
        this.rootContext.setFlowInstNode(instNode.getTaskId(), instNode);
        this.rootContext.setCurTaskId(cpnConfNode.getNodeId());
        try {
            if (this.conn.isClosed()) {
                this.conn = TConnPool.getDefaultPool().getConnection();
            }
            this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7f16\u53f7:" + this.batchId + "\uff0c\u6d41\u6c34\u53f7\uff1a" + this.batchSerialNo);
            Thread.sleep(1000L);
            String baseCpnId = cpnConfNode.getBaseCpnId();
            if (END.equals(baseCpnId)) {
                instTaskDao.updateTaskRunState(instNode.getTaskId(), TaskStateEnum.TASK_STATE_SUCCESS.getCode());
            } else {
                CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(this.conn);
                CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(cpnConfNode.getBaseCpnId());
                boolean exeFail = this.executeBaseCpnTask(instNode, cpnConfNode, confMaster);
                if (exeFail) {
                    throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u4ea7\u54c1\u7ec4\u4ef6\u7684\u57fa\u7840\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage(), e);
            this.handleUpdateAllState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_EXCEPTION.getCode(), BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode(), e.getMessage());
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBaseCpnTask(FlowInstNode taskInst, CpnConfNode taskConf, CpnConfMaster confMaster) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u57fa\u7840\u7ec4\u4ef6\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u5f53\u524d\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a" + this.getActiveCount());
            BaseTaskThread taskThread = new BaseTaskThread(this.batchInst, taskInst, taskConf, confMaster, this);
            if (this.threadPool == null || this.threadPool.isTerminated()) {
                this.threadPool = TThreadPools.getThreadPool(THREAD_POOL_NAME);
            }
            this.threadPool.execute(taskThread);
            this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continuePrdCpnTask(FlowInstNode taskInst, FlowConfNode taskConf) throws SQLException {
        block10: {
            FlowInstMasterDao batchInstDao = null;
            try {
                if (this.conn.isClosed()) {
                    this.conn = TConnPool.getDefaultPool().getConnection();
                }
                batchInstDao = new FlowInstMasterDao(this.conn);
                FlowConfNodeDao taskConfigDao = new FlowConfNodeDao(this.conn);
                this.curRunFlowConfNode = taskConfigDao.queryWithKeys(taskConf.getNextTaskId());
                if (END.equals(this.curRunFlowConfNode.getPluginId())) break block10;
                taskInst.setTaskId(this.curRunFlowConfNode.getTaskId());
                taskInst.setTaskName(this.curRunFlowConfNode.getTaskName());
                taskInst.setStageId(this.curRunFlowConfNode.getPluginId());
                CpnConfMasterDao cpnConfMasterDao = new CpnConfMasterDao(this.conn);
                CpnConfMaster confMaster = cpnConfMasterDao.queryWithKeys(this.curRunFlowConfNode.getPluginId());
                taskInst.setStageName(confMaster.getCpnName());
                taskInst.setEndTime(null);
                taskInst.setTaskRunState(TaskStateEnum.TASK_STATE_WTRUN.getCode());
                FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
                int n = instTaskDao.insertInst(taskInst);
                if (n > 0) {
                    batchInstDao.updateStage(this.curRunFlowConfNode.getTaskId(), this.curRunFlowConfNode.getTaskName(), this.batchSerialNo);
                    boolean exeFail = this.executePrdCpnTask(this.conn, taskInst, this.curRunFlowConfNode);
                    if (exeFail) {
                        throw new RuntimeException("\u4ea7\u54c1\u7ec4\u4ef6\u6267\u884c\u5931\u8d25");
                    }
                    break block10;
                }
                throw new RuntimeException("\u521b\u5efa\u4ea7\u54c1\u7ec4\u4ef6\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9\u5f02\u5e38");
            }
            catch (Exception e) {
                this.logger.error("\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u4e2a\u4ea7\u54c1\u7ec4\u4ef6\u4efb\u52a1\u5f02\u5e38", e);
                this.handleUpdateAllState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_EXCEPTION.getCode(), BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode(), e.getMessage());
            }
            finally {
                if (END.equals(this.curRunFlowConfNode.getPluginId())) {
                    FlowInstNodeDao instTaskDao = new FlowInstNodeDao(this.conn);
                    instTaskDao.updateTaskRunState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_SUCCESS.getCode());
                    if (null != this.batchInst) {
                        this.batchInst.setBatchState(BatchRunStateEnum.BATCH_STATE_FINISHED.getCode());
                        batchInstDao.updateBatchToEnd(this.batchInst);
                    }
                    this.logger.info("\u4e1a\u52a1\u6d41\u7a0b\u7ed3\u675f..." + Thread.currentThread().getName());
                }
                TConnPool.getDefaultPool().releaseConnection(this.conn);
            }
        }
    }

    private int getActiveCount() {
        return TThreadPools.getActiveCount(THREAD_POOL_NAME);
    }

    protected RootContext getRootContext() {
        return this.rootContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exeNextPrdTask(String targetNodeId) {
        Object instTaskDao = null;
        try {
            if (this.conn.isClosed()) {
                this.conn = TConnPool.getDefaultPool().getConnection();
            }
            FlowInstNode curTaskInstNode = this.rootContext.getFlowInstNode(this.rootContext.getCurTaskId());
            FlowConfNode curFlowConfNode = this.rootContext.getFlowConfNode(this.rootContext.getCurTaskId());
            curFlowConfNode.setNextTaskId(targetNodeId);
            this.continuePrdCpnTask(curTaskInstNode, curFlowConfNode);
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884c\u8def\u7531\u7ec4\u4ef6\u7684\u76ee\u6807\u4ea7\u54c1\u7ec4\u4ef6\u5f02\u5e38", e);
            this.handleUpdateAllState(this.curRunFlowConfNode.getTaskId(), TaskStateEnum.TASK_STATE_EXCEPTION.getCode(), BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode(), e.getMessage());
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }

    public void exeNextBaskTask(FlowInstNode flowInstNode, String targetNodeId) {
        CpnConfNode taskConf = new CpnConfNode();
        taskConf.setNextNodeId(targetNodeId);
        this.continueBaseCpnTask(flowInstNode, taskConf);
    }

    public boolean updateAllState(String taskId, ExecutorResult executorResult) {
        boolean r = true;
        String taskRunState = TaskStateEnum.TASK_STATE_SUCCESS.getCode();
        String batchRunState = null;
        if (CpnExecutorResult.REFUSE.equals((Object)executorResult.getCpnExecutorResult())) {
            taskRunState = TaskStateEnum.TASK_STATE_REFUSE.getCode();
        }
        if (CpnExecutorResult.HANG_UP.equals((Object)executorResult.getCpnExecutorResult())) {
            taskRunState = TaskStateEnum.TASK_STATE_HANG_UP.getCode();
        }
        if (CpnExecutorResult.EXCEPTION.equals((Object)executorResult.getCpnExecutorResult())) {
            taskRunState = TaskStateEnum.TASK_STATE_EXCEPTION.getCode();
        }
        if (FlowInstRunState.HANG_UP.equals((Object)executorResult.getFlowInstRunState())) {
            batchRunState = BatchRunStateEnum.BATCH_STATE_HANG_UP.getCode();
            r = false;
        }
        if (FlowInstRunState.EXCEPTION.equals((Object)executorResult.getFlowInstRunState())) {
            batchRunState = BatchRunStateEnum.BATCH_STATE_EXCEPTION.getCode();
            r = false;
        }
        if (FlowInstRunState.FINISH.equals((Object)executorResult.getFlowInstRunState()) && TaskStateEnum.TASK_STATE_REFUSE.getCode().equals(taskRunState)) {
            batchRunState = BatchRunStateEnum.BATCH_STATE_REFUSE.getCode();
            r = false;
        }
        this.handleUpdateAllState(taskId, taskRunState, batchRunState, null);
        return r;
    }

    private void handleUpdateAllState(String taskId, String taskRunState, String batchRunState, String remark) {
        FlowInstNodeDao instTaskDao = null;
        FlowInstMasterDao batchInstDao = null;
        try {
            if (this.conn.isClosed()) {
                this.conn = TConnPool.getDefaultPool().getConnection();
            }
            instTaskDao = new FlowInstNodeDao(this.conn);
            batchInstDao = new FlowInstMasterDao(this.conn);
            instTaskDao.updateTaskRunState(taskId, taskRunState);
            if (null != this.curRunFlowConfNode) {
                instTaskDao.updateTaskRunState(this.curRunFlowConfNode.getTaskId(), taskRunState);
            }
            if (null != this.batchInst && batchRunState != null) {
                this.batchInst.setBatchState(batchRunState);
                this.batchInst.setRemark(remark);
                batchInstDao.updateBatchToEnd(this.batchInst);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u6d41\u7a0b\u3001\u4efb\u52a1\u72b6\u6001\u5f02\u5e38", e);
            throw new RuntimeException(e);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
        }
    }
}

