/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.dao;

import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.NWfUserTodo;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NWfUserTodoDao {
    private static final Logger logger = LoggerFactory.getLogger(NWfUserTodoDao.class);
    Connection conn = null;

    public NWfUserTodoDao(Connection conn) {
        this.conn = conn;
    }

    public NWfUserTodo queryWithKeys(String nodeId) throws SQLException {
        NWfUserTodo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM n_wf_user_todo WHERE node_id=?");
            ps.setString(1, nodeId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (NWfUserTodo)POJOUtils.generatePOJO((ResultSet)rs, NWfUserTodo.class);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfMasterWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<NWfUserTodo> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<NWfUserTodo> dcList = new ArrayList<NWfUserTodo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM n_wf_user_todo " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                NWfUserTodo dc = new NWfUserTodo();
                dc.setBatchId(rs.getString("batch_Id"));
                dc.setNodeId(rs.getString("node_Id"));
                dc.setUserId(rs.getString("user_Id"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setNodeName(rs.getString("node_name"));
                dc.setStartTime(rs.getString("start_time"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryNWfUserTodoWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public void updateStage(NWfUserTodo nWfUserTodo) throws SQLException {
        PreparedStatement ps = null;
        try {
            NWfUserTodoDao nWfUserTodoDao = new NWfUserTodoDao(this.conn);
            NWfUserTodo nWfUserTodoInfo = nWfUserTodoDao.queryWithKeys(nWfUserTodo.getNodeId());
            ps = this.conn.prepareStatement("update n_wf_user_todo set batch_state=?,stage_id=?,stage_name=? where node_id=?");
            ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
    }

    public int insertNWfUserTodo(NWfUserTodo nWfUserTodo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into n_wf_user_todo ( batch_id,batch_serial_no,instance_id,node_id,node_name,user_id,user_name,start_time,last_user_id,last_user_name) values (?,?,?,?,?,?,?,?,?,?)");
            ps.setObject(1, nWfUserTodo.getBatchId());
            ps.setObject(2, nWfUserTodo.getBatchSerialNo());
            ps.setObject(3, nWfUserTodo.getInstanceId());
            ps.setObject(4, nWfUserTodo.getNodeId());
            ps.setObject(5, nWfUserTodo.getNodeName());
            ps.setObject(6, nWfUserTodo.getUserId());
            ps.setObject(7, nWfUserTodo.getUserName());
            ps.setObject(8, nWfUserTodo.getStartTime());
            ps.setObject(9, nWfUserTodo.getLastUserId());
            ps.setObject(10, nWfUserTodo.getLastUserName());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert n_wf_user_todo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

