/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin;

import com.irdstudio.allinflow.executor.application.executor.core.plugin.IJCIPlugin;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginLogService;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.PathUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.StreamGobbler;
import com.irdstudio.allinflow.executor.facade.dto.ValidateRtnDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractPlugin<T>
implements IJCIPlugin<T> {
    protected PluginContext context;
    protected ILogger logger;
    protected PluginLogService logService;
    protected String binPath;
    protected T batchRunProcess;

    @Override
    public void setPluginContext(PluginContext context) {
        this.context = context;
        this.logger = TLogger.getLogger(context.getSzBatchSn());
        this.binPath = PathUtil.getClassRootPath();
    }

    @Override
    public void setPluginContext(PluginContext context, T batchRunProcess) {
        this.context = context;
        this.batchRunProcess = batchRunProcess;
        this.logger = TLogger.getLogger(context.getSzBatchSn());
        this.binPath = PathUtil.getClassRootPath();
    }

    @Override
    public void setPluginContext(PluginContext context, ILogger logger) {
        this.context = context;
        this.logger = logger;
        this.binPath = PathUtil.getClassRootPath();
    }

    public void setLogService(PluginLogService logService) {
        this.logService = logService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readPluginConfigureFromDB(String szConfIdentify) {
        boolean flag = true;
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            flag = this.doReadConfigureFromDB(conn, szConfIdentify);
        }
        catch (SQLException e) {
            this.context.setSzLastErrorMsg(e.getMessage());
            flag = false;
            this.logger.error("\u8bfb\u53d6\u63d2\u4ef6\u6240\u9700\u8981\u7684\u914d\u7f6e\u6570\u636e\u5931\u8d25", e);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return flag;
    }

    @Override
    public boolean readPluginConfigureFromFile(String szConfIdentify) {
        return false;
    }

    public boolean copyConfig(String oldFlowNodeId, String newFlowNodeId) {
        return false;
    }

    protected abstract boolean doReadConfigureFromDB(Connection var1, String var2) throws SQLException;

    public void testVariable() {
        this.logger.info("\u5f53\u524d\u5b50\u7cfb\u7edf\u4ee3\u7801:" + this.context.getVv().getValue("subs_code"));
        this.logger.info("\u5f53\u524d\u6570\u636e\u65e5\u671f:" + this.context.getCurrentDataDate());
        this.logger.info("\u4e0a\u4e00\u6570\u636e\u65e5\u671f:" + this.context.getLastDataDate());
        this.logger.info("\u6570\u636e\u88c5\u8f7d\u5b8c\u6210\u65e5\u671f:" + this.context.getLoadFinishedDate());
        this.logger.info("\u6279\u6b21\u5b8c\u6210\u65e5\u671f:" + this.context.getBatFinishedDate());
        this.logger.info("\u4e0b\u4e00\u65e5\u671f(\u6570\u636e\u65e5\u671f+1):" + this.context.getNextDataDate());
    }

    public boolean verifyConfig() {
        return true;
    }

    public void writeSuccessLog(String szActionName, String szActionDetailDesc) {
        this.logger.info(szActionName + "\u6210\u529f! " + szActionDetailDesc);
        this.logService.writePluginInstLog(this.context.getSzBatchSn(), this.context.getnPluginId(), this.context.getSzPluginName(), szActionName, "1", szActionDetailDesc, this.context.getSzTaskId(), this.context.getSzTaskName());
    }

    public void writeSuccessLog(String szActionName) {
        this.logger.info(szActionName + "\u6210\u529f! ");
        this.logService.writePluginInstLog(this.context.getSzBatchSn(), this.context.getnPluginId(), this.context.getSzPluginName(), szActionName + "\u6210\u529f! ", "1", "", this.context.getSzTaskId(), this.context.getSzTaskName());
    }

    public void writeWarningLog(String szActionName, String szActionDetailDesc) {
        this.logger.info(szActionName + "\u4ea7\u751f\u8b66\u544a!  " + szActionDetailDesc);
        this.logService.writePluginInstLog(this.context.getSzBatchSn(), this.context.getnPluginId(), this.context.getSzPluginName(), szActionName, "2", szActionDetailDesc, this.context.getSzTaskId(), this.context.getSzTaskName());
    }

    public void writeFaildLog(String szActionName, String szActionDetailDesc) {
        this.context.setSzLastErrorMsg(szActionDetailDesc);
        this.writeFaildLog(szActionName);
    }

    public void writeFaildLog(String szActionName) {
        this.logger.info(szActionName + "\u5931\u8d25!  " + this.context.getLastErrorMsg());
        this.logService.writePluginInstLog(this.context.getSzBatchSn(), this.context.getnPluginId(), this.context.getSzPluginName(), szActionName + "\u5931\u8d25!", "3", this.context.getLastErrorMsg(), this.context.getSzTaskId(), this.context.getSzTaskName());
    }

    public Connection getPluginConnection() {
        Connection conn = null;
        try {
            conn = this.context.getPluginConnection();
        }
        catch (SQLException e) {
            this.context.setSzLastErrorMsg("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25!" + e.getMessage());
            this.logger.error("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25!" + e.getMessage());
        }
        return conn;
    }

    public void closePluginConnection(Connection conn) {
        this.context.releasePluginConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSql(String sql) {
        boolean flag = true;
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getPluginConnection();
            st = conn.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            this.context.setSzLastErrorMsg(e.getMessage());
            flag = false;
            this.context.setSzLastErrorMsg(e.getMessage());
            this.logger.error(e.getMessage());
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                    st = null;
                }
                catch (SQLException e) {
                    this.context.setSzLastErrorMsg(e.getMessage());
                    this.logger.error(e.getMessage());
                }
            }
            this.closePluginConnection(conn);
        }
        return flag;
    }

    public void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
    }

    protected boolean isInValidConf(String curDate, String validDate, String inValidDate) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean callExternCmd(String[] params) {
        if (params == null || params.length < 1) {
            this.context.setSzLastErrorMsg("\u65e0\u6548\u7684\u5916\u90e8\u547d\u4ee4\u8c03\u7528\u65b9\u5f0f!");
            return false;
        }
        boolean bFlag = true;
        int exitVal = -1;
        Process p = null;
        String szInfo = "";
        StringBuffer szFullCmd = new StringBuffer(params[0]);
        for (int i = 1; i < params.length; ++i) {
            szFullCmd.append(" ").append(params[i]);
        }
        Runtime rt = Runtime.getRuntime();
        try {
            p = params.length == 1 ? rt.exec(params[0]) : rt.exec(params);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            errorGobbler.start();
            StreamGobbler outGobbler = new StreamGobbler(p.getInputStream(), "STDOUT");
            outGobbler.start();
            exitVal = p.waitFor();
            szInfo = "\u8fd4\u56de\u503c\uff1a" + exitVal + "\uff0c\u6267\u884c\u4fe1\u606f:" + errorGobbler.getInfo() + outGobbler.getInfo();
            this.context.setSzLastErrorMsg(szInfo);
        }
        catch (Exception ex) {
            bFlag = false;
            this.writeFaildLog("\u6267\u884c\u5916\u90e8\u547d\u4ee4\uff1a" + szFullCmd, szInfo);
            this.logger.error(ex.getMessage());
        }
        finally {
            if (p != null) {
                if (exitVal == 0) {
                    bFlag = true;
                    this.writeSuccessLog("\u6267\u884c\u5916\u90e8\u547d\u4ee4\uff1a" + szFullCmd, szInfo);
                } else {
                    bFlag = false;
                    this.writeFaildLog("\u6267\u884c\u5916\u90e8\u547d\u4ee4\uff1a" + szFullCmd, szInfo);
                }
            }
        }
        return bFlag;
    }

    protected boolean callExternCmd(String cmd, String[] params) {
        String[] cmdParams = new String[params == null ? 1 : params.length + 1];
        cmdParams[0] = cmd;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                cmdParams[i + 1] = params[i];
            }
        }
        return this.callExternCmd(cmdParams);
    }

    protected boolean callExternCmd(String cmd) {
        String[] cmdParams = new String[]{cmd};
        return this.callExternCmd(cmdParams);
    }

    protected boolean isSuccess(String result, String[] opt) {
        int r = this.toNotNullAndTrim(result).compareTo(opt[2]);
        if (opt[1].equals(">")) {
            if (r <= 0) {
                return false;
            }
        } else if (opt[1].equals(">=")) {
            if (r < 0) {
                return false;
            }
        } else if (opt[1].equals("=")) {
            if (r < 0 || r > 0) {
                return false;
            }
        } else if (opt[1].equals("<")) {
            if (r >= 0) {
                return false;
            }
        } else if (opt[1].equals("<=")) {
            if (r > 0) {
                return false;
            }
        } else if (opt[1].equals("<>") || opt[1].equals("!=")) {
            if (r == 0) {
                return false;
            }
        } else {
            this.context.setSzLastErrorMsg("Operator [" + opt[1] + "] is illegal.");
            return false;
        }
        return true;
    }

    protected String[] parseExpression(String expression) {
        int k;
        String col = null;
        String symbol = null;
        String clause = null;
        int i = (expression = expression.replaceAll(" ", "")).indexOf("{");
        if (i == -1) {
            this.context.setSzLastErrorMsg("illegal expression,lack of leads{");
            return null;
        }
        int j = expression.indexOf("}", i);
        if (j == -1) {
            this.context.setSzLastErrorMsg("illegal expression,lack of encloseure }");
            this.logger.info(this.context.getLastErrorMsg());
            return null;
        }
        switch (expression.charAt(j + 2)) {
            case '=': 
            case '>': {
                k = 2;
                break;
            }
            default: {
                k = 1;
            }
        }
        col = expression.substring(i + 1, j);
        symbol = expression.substring(j + 1, j + 1 + k);
        clause = expression.substring(j + 1 + k);
        return new String[]{col, symbol, clause};
    }

    protected String toNotNullAndTrim(String str) {
        return str == null ? "" : str.trim();
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return false;
    }
}

