/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin.approve;

import com.irdstudio.allinflow.deliver.console.facade.FlowInstTodoForApproveService;
import com.irdstudio.allinflow.executor.application.executor.core.batch.AprRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.batch.BaseContext;
import com.irdstudio.allinflow.executor.application.executor.core.batch.CpnExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.batch.ExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.batch.FlowInstRunState;
import com.irdstudio.allinflow.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.NWfInstanceDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.NWfNodeDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.NWfInstance;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.NWfNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinflow.executor.application.executor.core.util.vo.VariableValue;
import com.irdstudio.allinflow.flow.console.facade.NWfOrsingConfigService;
import com.irdstudio.allinflow.flow.console.facade.dto.NWfOrsingConfigDto;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrsignApprove
extends AbstractPlugin<AprRunProcess> {
    protected FlowInstMaster batchInst = null;
    protected Map<String, Object> extParam;
    protected NWfOrsingConfigDto nWfOrsingConfigDto;
    @Autowired
    protected FlowInstTodoForApproveService flowInstTodoForApproveService;
    @Autowired
    protected NWfOrsingConfigService nWfOrsingConfigService;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        try {
            String batchSerialNo = this.context.getSzBatchSn();
            FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
            this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
            this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
            this.nWfOrsingConfigDto = new NWfOrsingConfigDto();
            this.nWfOrsingConfigDto.setBatchId(this.batchInst.getBatchId());
            this.nWfOrsingConfigDto.setNodeId(this.context.getFlowConfNode().getTaskId());
            this.nWfOrsingConfigDto.setNodeName(this.batchInst.getBatchSerialNo());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return true;
    }

    public boolean execute() {
        try {
            Connection conn = null;
            conn = TConnPool.getDefaultPool().getConnection();
            VariableValue variableValue = this.context.getVv();
            String szTaskId = this.context.getSzTaskId();
            String nodeUser = this.nWfOrsingConfigDto.getUserId();
            if (!StringUtils.isBlank((String)nodeUser)) {
                String[] users = nodeUser.split(",");
                String nodeName = this.nWfOrsingConfigDto.getNodeName();
                NWfInstance nWfInstance = new NWfInstance();
                nWfInstance.setBatchId(this.nWfOrsingConfigDto.getBatchId());
                String randomString = OrsignApprove.generateRandomString(10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
                nWfInstance.setInstanceId(randomString);
                nWfInstance.setNodeId(this.nWfOrsingConfigDto.getNodeId());
                nWfInstance.setNodeName(this.nWfOrsingConfigDto.getNodeName());
                nWfInstance.setNodeAdmin("huawei");
                nWfInstance.setStartTime(CurrentDateUtil.getTodayDateEx2());
                nWfInstance.setSystemId("");
                nWfInstance.setOrgId("");
                nWfInstance.setBizId("");
                nWfInstance.setBizUserId("");
                nWfInstance.setBizUserName("");
                nWfInstance.setUserId(this.nWfOrsingConfigDto.getUserId());
                nWfInstance.setNodeState("");
                nWfInstance.setNodeParam("");
                nWfInstance.setBizType(this.nWfOrsingConfigDto.getBizType());
                nWfInstance.setEx(this.nWfOrsingConfigDto.getEx());
                nWfInstance.setPageUrl(this.nWfOrsingConfigDto.getPageUrl());
                NWfInstanceDao nWfInstanceDao = new NWfInstanceDao(conn);
                nWfInstanceDao.insertNWfInstance(nWfInstance);
                NWfNode nWfNode = new NWfNode();
                nWfNode.setBatchId(this.nWfOrsingConfigDto.getBatchId());
                nWfNode.setInstanceId(randomString);
                nWfNode.setNodeId(this.nWfOrsingConfigDto.getNodeId());
                nWfNode.setNodeName(this.nWfOrsingConfigDto.getNodeName());
                nWfNode.setNodeState("");
                nWfNode.setStartTime(CurrentDateUtil.getTodayDateEx2());
                nWfNode.setOrgId("");
                nWfNode.setLastNodeId("");
                nWfNode.setLastNodeName("");
                nWfNode.setUserId(this.nWfOrsingConfigDto.getUserId());
                NWfNodeDao nWfNodeDao = new NWfNodeDao(conn);
                nWfNodeDao.insertNWfNode(nWfNode);
                int n = this.flowInstTodoForApproveService.insertFlowInstTodo(this.nWfOrsingConfigDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String generateRandomString(int length, String allowedChars) {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(allowedChars.charAt(secureRandom.nextInt(allowedChars.length())));
        }
        return sb.toString();
    }

    @Override
    public ExecutorResult execute(BaseContext params) {
        try {
            int n = this.flowInstTodoForApproveService.insertFlowInstTodo(this.nWfOrsingConfigDto);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return ExecutorResult.of(CpnExecutorResult.HANG_UP, FlowInstRunState.HANG_UP, null, "\u7ec4\u4ef6\u6267\u884c\u6210\u529f");
    }
}

