/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin.common;

import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfParam;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpnConfParamDao {
    private static final Logger logger = LoggerFactory.getLogger(CpnConfParamDao.class);
    Connection conn = null;
    private static final String TABLE_NAME = "cpn_conf_param";

    public CpnConfParamDao(Connection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CpnConfParam> selectByCpnId(String cpnId) {
        String sql = "SELECT * FROM cpn_conf_param WHERE cpn_id = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<CpnConfParam> result = new ArrayList<CpnConfParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            ps.setString(1, cpnId);
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add((CpnConfParam)POJOUtils.generatePOJO((ResultSet)rs, CpnConfParam.class));
            }
            this.closeResources(rs, ps);
        }
        catch (SQLException e) {
            try {
                logger.error("\u67e5\u8be2\u7ec4\u4ef6\u53c2\u6570\u5931\u8d25: {}", (Object)e.getMessage());
                this.closeResources(rs, ps);
            }
            catch (Throwable throwable) {
                this.closeResources(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchInsert(List<CpnConfParam> params) {
        String sql = "INSERT INTO cpn_conf_param (cpn_id, param_name, param_desc, param_inout_type, in_eval_method) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (CpnConfParam param : params) {
                ps.setString(1, param.getCpnId());
                ps.setString(2, param.getParamName());
                ps.setString(3, param.getParamDesc());
                ps.setString(4, String.valueOf(param.getParamInoutType()));
                ps.setString(5, String.valueOf(param.getInEvalMethod()));
                ps.addBatch();
            }
            int n = ps.executeBatch().length;
            return n;
        }
        catch (SQLException e) {
            logger.error("\u6279\u91cf\u63d2\u5165\u7ec4\u4ef6\u53c2\u6570\u5931\u8d25: {}", (Object)e.getMessage());
            int n = 0;
            return n;
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByCpnId(String cpnId) {
        String sql = "DELETE FROM cpn_conf_param WHERE cpn_id = ?";
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            ps.setString(1, cpnId);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            logger.error("\u5220\u9664\u7ec4\u4ef6\u53c2\u6570\u5931\u8d25: {}", (Object)e.getMessage());
            int n = 0;
            return n;
        }
        finally {
            this.closeResources(null, ps);
        }
    }

    private void closeResources(ResultSet rs, PreparedStatement ps) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            logger.error("\u5173\u95ed\u8d44\u6e90\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

