/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.rest.schedule;

import com.irdstudio.allinflow.executor.application.executor.core.dao.SSrvsCronConfDao;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinflow.executor.application.executor.rest.schedule.QuartzJobEngine;
import com.irdstudio.allinflow.executor.application.executor.rest.schedule.QuartzManager;
import com.irdstudio.allinflow.executor.types.ExecutorInstInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleJobUtil {
    public static final String STATE_WAIT = "S";
    public static final String STATE_ARRANGED = "A";
    public static final String STATE_RUNNING = "R";
    public static final String STATE_FALSE = "F";
    private static Logger logger = LoggerFactory.getLogger(ScheduleJobUtil.class);
    public static String JOB_GROUP_NAME = "AGENT_JOB_GROUP";
    public static String TRIGGER_NAME = "AGENT_TRIGGER";
    public static String TRIGGER_GROUP_NAME = "AGENT_TRIGGER_GROUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJobsForExecutor() {
        logger.info("\u5f00\u59cb\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            SSrvsCronConfDao sSrvsCronConfDao = new SSrvsCronConfDao(conn);
            List<SSrvsCronConf> cronConfList = sSrvsCronConfDao.queryByAgentId(ExecutorInstInfo.EXECUTOR_ID);
            for (SSrvsCronConf cronConf : cronConfList) {
                if (cronConf.getJobState().equals(STATE_WAIT)) {
                    cronConf.setJobState(STATE_ARRANGED);
                    sSrvsCronConfDao.updateByPk(cronConf);
                }
                logger.info("\u52a0\u5165\u5b9a\u65f6\u4efb\u52a1\uff1a" + cronConf.getJobDesc() + "...");
                QuartzManager.addJob(cronConf.getJobCode(), JOB_GROUP_NAME, TRIGGER_NAME + "-" + cronConf.getJobCode(), TRIGGER_GROUP_NAME, QuartzJobEngine.class, cronConf.getCronExpression());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        logger.info("\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }

    public static void stopJobsForAgent() {
        logger.info("\u5f00\u59cb\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            QuartzManager.shutdownJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }
}

