/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.service.impl;

import com.irdstudio.allinflow.executor.application.executor.core.plugin.IJCIPlugin;
import com.irdstudio.allinflow.executor.facade.PluginExecutorService;
import com.irdstudio.allinflow.executor.facade.dto.PluginExecutorDTO;
import com.irdstudio.allinflow.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pluginExecutorServiceImpl")
public class PluginExecutorServiceImpl
implements PluginExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(PluginExecutorServiceImpl.class);

    public ResponseData<ValidateRtnDTO> validate(PluginExecutorDTO param) {
        String pluginClass = param.getPluginClass();
        try {
            Class<?> clazz = Class.forName(pluginClass);
            IJCIPlugin pluginInst = (IJCIPlugin)clazz.newInstance();
            ValidateRtnDTO message = new ValidateRtnDTO();
            boolean flag = pluginInst.validate(param.getBatchId(), param.getTaskId(), message);
            if (flag) {
                return ResponseData.create((Object)message, (String)"999999", (String)"\u6821\u9a8c\u6210\u529f", (boolean)true);
            }
            return ResponseData.create((Object)message, (String)"000000", (String)String.format("%s%s", StringUtils.join((Iterable)message.getMessage(), (String)","), message.getErrorMsgSuffix()), (boolean)false);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResponseData.create(null, (String)"000000", (String)"\u627e\u4e0d\u5230\u63d2\u4ef6\u5b9e\u73b0\u7c7b", (boolean)false);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResponseData.create(null, (String)"000000", (String)"\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f8b", (boolean)false);
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResponseData.create(null, (String)"000000", (String)"\u63d2\u4ef6\u6821\u9a8c\u65b9\u6cd5\u6267\u884c\u5f02\u5e38", (boolean)false);
        }
    }

    public ResponseData<Boolean> copyConfig(PluginExecutorDTO param) {
        try {
            String pluginClass = param.getPluginClass();
            Class<?> clazz = Class.forName(pluginClass);
            IJCIPlugin pluginInst = (IJCIPlugin)clazz.newInstance();
            pluginInst.copyConfig(param.getBatchId(), param.getTaskId(), param.getNewTaskId());
            return ResponseData.create((Object)true, (String)"999999", (String)"\u590d\u5236\u6210\u529f", (boolean)true);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u63d2\u4ef6\u53c2\u6570\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            return ResponseData.create((Object)false, (String)"000000", (String)"\u590d\u5236\u6210\u529f", (boolean)false);
        }
    }
}

