/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.service.impl;

import com.irdstudio.allinflow.executor.application.service.task.OpStategyFactory;
import com.irdstudio.allinflow.executor.application.service.task.inter.OpStrategy;
import com.irdstudio.allinflow.executor.facade.TaskFlowEngineService;
import com.irdstudio.allinflow.executor.facade.dto.FlowInstTaskDTO;
import com.irdstudio.allinflow.executor.facade.dto.FlowNodeUsrDTO;
import com.irdstudio.allinflow.executor.types.AssOpType;
import com.irdstudio.allinflow.executor.types.HandOpType;
import com.irdstudio.allinflow.executor.types.TskListType;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="taskFlowEngineServiceImpl")
public class TaskFlowEngineServiceImpl
implements TaskFlowEngineService {
    public static Logger logger = LoggerFactory.getLogger(TaskFlowEngineServiceImpl.class);

    public ResponseData<FlowInstTaskDTO> tskHandle(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getStrategy(HandOpType.getByCode((String)flowInstTaskDTO.getOpType()));
        FlowInstTaskDTO r = (FlowInstTaskDTO)opStrategy.process(flowInstTaskDTO);
        if (StringUtils.isNotBlank((String)r.getResultMessage())) {
            String code = StringUtils.isNotBlank((String)r.getResultCode()) ? r.getResultCode() : "999999";
            return ResponseData.create((Object)r, (String)code, (String)r.getResultMessage(), (boolean)true);
        }
        return ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
    }

    public ResponseData<FlowInstTaskDTO> tskAssRect(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getStrategy(AssOpType.getByCode((String)flowInstTaskDTO.getOpType()));
        FlowInstTaskDTO r = (FlowInstTaskDTO)opStrategy.process(flowInstTaskDTO);
        if (StringUtils.isNotBlank((String)r.getResultMessage())) {
            String code = StringUtils.isNotBlank((String)r.getResultCode()) ? r.getResultCode() : "999999";
            return ResponseData.create((Object)r, (String)code, (String)r.getResultMessage(), (boolean)true);
        }
        return ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
    }

    public ResponseData<List<FlowInstTaskDTO>> qryTaskList(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getTskListStrategy(TskListType.getByCode((String)flowInstTaskDTO.getQryType()));
        List r = (List)opStrategy.process(flowInstTaskDTO);
        ResponseData responseData = ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
        if (CollectionUtils.isNotEmpty((Collection)r)) {
            responseData.setTotal(((FlowInstTaskDTO)r.get(0)).getTotal().intValue());
        }
        return responseData;
    }

    public ResponseData<List<FlowNodeUsrDTO>> qryRetInfoList(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getRetInfoStrategy();
        List r = (List)opStrategy.process(flowInstTaskDTO);
        return ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
    }

    public ResponseData<FlowInstTaskDTO> tskCreated(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getTskCreatedStrategy();
        FlowInstTaskDTO r = (FlowInstTaskDTO)opStrategy.process(flowInstTaskDTO);
        if (StringUtils.isNotBlank((String)r.getResultMessage())) {
            String code = StringUtils.isNotBlank((String)r.getResultCode()) ? r.getResultCode() : "999999";
            return ResponseData.create((Object)r, (String)code, (String)r.getResultMessage(), (boolean)true);
        }
        return ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
    }

    public ResponseData<FlowInstTaskDTO> tskDetailsQry(FlowInstTaskDTO flowInstTaskDTO) {
        OpStrategy opStrategy = OpStategyFactory.getTskDetailsStrategy();
        FlowInstTaskDTO r = (FlowInstTaskDTO)opStrategy.process(flowInstTaskDTO);
        if (StringUtils.isNotBlank((String)r.getResultMessage())) {
            String code = StringUtils.isNotBlank((String)r.getResultCode()) ? r.getResultCode() : "999999";
            return ResponseData.create((Object)r, (String)code, (String)r.getResultMessage(), (boolean)true);
        }
        return ResponseData.create((Object)r, (String)"000000", (String)"\u5904\u7406\u6210\u529f", (boolean)true);
    }
}

