/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.irdstudio.allinflow.executor.application.executor.core.batch.AprRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.batch.ExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginAprExecutor;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginLogService;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.Convert;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class AprTaskThread
extends Thread {
    private FlowInstMaster batchInst = null;
    private FlowInstNode taskInst = null;
    private FlowConfNode taskConf = null;
    private ILogger logger = null;
    private PluginLogService taskLogService = null;
    public AprRunProcess aprRunProcess;
    private CpnConfMaster confMaster;

    public AprTaskThread(FlowInstMaster batchInst, FlowInstNode taskInst, FlowConfNode taskConf, CpnConfMaster confMaster, AprRunProcess aprRunProcess) {
        this.batchInst = batchInst;
        this.taskInst = taskInst;
        this.taskConf = taskConf;
        this.confMaster = confMaster;
        this.taskLogService = PluginLogService.getInstance();
        this.aprRunProcess = aprRunProcess;
    }

    @Override
    public void run() {
        this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
        this.doNomalTask();
    }

    private void doNomalTask() {
        this.logger.debug("\u5ba1\u6279\u7ec4\u4ef6\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        PluginContext ctx = this.newPluginContext();
        ExecutorResult executorResult = this.callPlugin(ctx);
        boolean r = this.aprRunProcess.updateAllState(this.taskInst.getTaskId(), executorResult);
        if (r) {
            if (StringUtils.isNotBlank((CharSequence)ctx.getTargetNodeId())) {
                this.aprRunProcess.exeNextPrdTask(ctx.getTargetNodeId());
            } else {
                try {
                    this.aprRunProcess.continueAprCpnTask(this.taskInst, this.taskConf);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.logger.debug("\u5ba1\u6279\u7ec4\u4ef6\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
        }
    }

    private PluginContext newPluginContext() {
        PluginContext ctx = new PluginContext();
        ctx.setnPluginId(this.taskConf.getPluginId());
        ctx.setnPluginConfType(Convert.StrToInt(this.taskConf.getPluginSourceType(), 1));
        ctx.setSzPluginConfId(this.taskConf.getPluginParaFlag());
        ctx.setSzBatchSn(this.batchInst.getBatchSerialNo());
        ctx.setSzBatchId(this.batchInst.getBatchId());
        ctx.setSzTaskId(this.taskInst.getTaskId());
        ctx.setPreTaskId(this.taskConf.getPreviousTaskId());
        ctx.setSzTaskName(this.taskInst.getTaskName());
        ctx.setSzSubsCode(this.batchInst.getSubsId());
        ctx.setSzSubsDsCode(this.taskConf.getSubsDsCode());
        ctx.setFlowConfSource(this.aprRunProcess.getFlowConfSource());
        ctx.setPluginType(this.taskConf.getPluginType());
        ctx.setFlowConfNode(this.taskConf);
        ctx.setFlowInstNode(this.taskInst);
        ctx.setRootContext(this.aprRunProcess.getRootContext());
        if (this.confMaster != null) {
            ctx.setPluginClass(this.confMaster.getCpnClass());
        }
        return ctx;
    }

    private ExecutorResult callPlugin(PluginContext ctx) {
        ExecutorResult bIsCallSuccess;
        try {
            this.taskLogService.updateBatchTaskToRunning(ctx.getSzTaskId(), this.taskInst.getBatchSerialNo());
            bIsCallSuccess = PluginAprExecutor.callPlugin(ctx, this.aprRunProcess);
        }
        catch (SQLException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        return bIsCallSuccess;
    }
}

