/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.batch;

import com.irdstudio.allinflow.executor.application.executor.core.batch.BatchRunProcess;
import com.irdstudio.allinflow.executor.application.executor.core.batch.ExecutorResult;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.CpnConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfNode;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowInstNode;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginContext;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginExecutor;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.PluginLogService;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.application.executor.core.util.pub.Convert;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class BaseTaskThread
extends Thread {
    private FlowInstMaster batchInst = null;
    private FlowInstNode taskInst = null;
    private CpnConfNode taskConf = null;
    private CpnConfMaster confMaster;
    private FlowConfNode flowConfNode = null;
    private ILogger logger = null;
    private PluginLogService taskLogService = null;
    public BatchRunProcess batchRunProcess;

    public BaseTaskThread(FlowInstMaster batchInst, FlowInstNode taskInst, CpnConfNode taskConf, CpnConfMaster confMaster, BatchRunProcess batchRunProcess) {
        this.batchInst = batchInst;
        this.taskInst = taskInst;
        this.taskConf = taskConf;
        this.taskLogService = PluginLogService.getInstance();
        this.batchRunProcess = batchRunProcess;
        this.flowConfNode = new FlowConfNode();
        this.flowConfNode.setTaskId(taskConf.getNodeId());
        this.flowConfNode.setTaskSkipTactic(taskConf.getNodeSkipTactic());
        this.confMaster = confMaster;
    }

    @Override
    public void run() {
        this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
        this.doNomalTask();
    }

    private void doNomalTask() {
        this.logger.debug("\u57fa\u7840\u7ec4\u4ef6\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u5f00\u59cb\u8fd0\u884c...");
        PluginContext ctx = this.newPluginContext();
        ExecutorResult executorResult = this.callPlugin(ctx);
        boolean r = this.batchRunProcess.updateAllState(this.taskInst.getTaskId(), executorResult);
        if (r) {
            if (StringUtils.isNotBlank((CharSequence)ctx.getTargetNodeId())) {
                this.batchRunProcess.exeNextBaskTask(this.taskInst, ctx.getTargetNodeId());
            } else {
                this.batchRunProcess.continueBaseCpnTask(this.taskInst, this.taskConf);
            }
            this.logger.debug("\u57fa\u7840\u7ec4\u4ef6\u666e\u901a\u4efb\u52a1:" + this.taskInst.getTaskName() + "\u8fd0\u884c\u5b8c\u6210");
        }
    }

    private PluginContext newPluginContext() {
        PluginContext ctx = new PluginContext();
        ctx.setnPluginId(this.taskConf.getBaseCpnId());
        ctx.setnPluginConfType(Convert.StrToInt(this.taskConf.getPluginSourceType(), 1));
        ctx.setSzPluginConfId(this.taskConf.getPluginParaFlag());
        ctx.setSzBatchSn(this.batchInst.getBatchSerialNo());
        ctx.setSzBatchId(this.batchInst.getBatchId());
        ctx.setSzTaskId(this.taskInst.getTaskId());
        ctx.setPreTaskId(this.taskConf.getPreviousNodeId());
        ctx.setSzTaskName(this.taskInst.getTaskName());
        ctx.setSzSubsCode(this.batchInst.getSubsId());
        ctx.setSzSubsDsCode(this.taskConf.getSubsDsCode());
        ctx.setFlowConfSource(this.batchRunProcess.getFlowConfSource());
        ctx.setPluginType(this.taskConf.getBaseCpnType());
        ctx.setRootContext(this.batchRunProcess.getRootContext());
        if (this.confMaster != null) {
            ctx.setPluginClass(this.confMaster.getCpnClass());
        }
        return ctx;
    }

    private ExecutorResult callPlugin(PluginContext ctx) {
        ExecutorResult bIsCallSuccess;
        try {
            this.taskLogService.updateBatchTaskToRunning(ctx.getSzTaskId(), this.taskInst.getBatchSerialNo());
            bIsCallSuccess = PluginExecutor.callPlugin(ctx, this.batchRunProcess);
        }
        catch (SQLException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            bIsCallSuccess = ExecutorResult.err(null, e.getMessage());
            this.logger.error(e.getMessage(), e);
        }
        return bIsCallSuccess;
    }
}

