/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.dao;

import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.FlowConfLocale;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class FlowConfLocaleDao {
    Connection conn = null;

    public FlowConfLocaleDao(Connection conn) {
        this.conn = conn;
    }

    public FlowConfLocale queryWithKeys(String localeId) throws SQLException {
        FlowConfLocale dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM FLOW_CONF_LOCALE WHERE locale_id=?");
            ps.setString(1, localeId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new FlowConfLocale();
                dc.setLocaleId(rs.getString("locale_id"));
                dc.setLocaleName(rs.getString("locale_name"));
                dc.setLocaleType(rs.getString("locale_type"));
                dc.setLocaleIp(rs.getString("locale_ip"));
                dc.setLocalePort(rs.getString("locale_port"));
                dc.setLoginType(rs.getString("login_type"));
                dc.setLoginUser(rs.getString("login_user"));
                dc.setLoginPwd(rs.getString("login_pwd"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfLocaleWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<FlowConfLocale> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<FlowConfLocale> dcList = new ArrayList<FlowConfLocale>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM FLOW_CONF_LOCALE " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                FlowConfLocale dc = new FlowConfLocale();
                dc.setLocaleId(rs.getString("locale_id"));
                dc.setLocaleName(rs.getString("locale_name"));
                dc.setLocaleType(rs.getString("locale_type"));
                dc.setLocaleIp(rs.getString("locale_ip"));
                dc.setLocalePort(rs.getString("locale_port"));
                dc.setLoginType(rs.getString("login_type"));
                dc.setLoginUser(rs.getString("login_user"));
                dc.setLoginPwd(rs.getString("login_pwd"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfLocaleWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

