/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.plugin;

import com.irdstudio.allinflow.executor.annotation.cpn.RouteCpnRegister;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMaster;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.common.CpnConfMasterDao;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import java.sql.Connection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

@Component
public class RouteCpnRegistrationHandler
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(RouteCpnRegistrationHandler.class);
    private static final String BASE_PACKAGE = "com.irdstudio.allinflow.executor.application.executor.core.plugin";

    public void run(ApplicationArguments args) throws Exception {
        Connection conn = null;
        conn = TConnPool.getDefaultPool().getConnection();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RouteCpnRegister.class));
        CpnConfMasterDao dao = new CpnConfMasterDao(conn);
        scanner.findCandidateComponents(BASE_PACKAGE).forEach(beanDefinition -> {
            try {
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                RouteCpnRegister annotation = clazz.getAnnotation(RouteCpnRegister.class);
                this.registerComponent(dao, annotation);
            }
            catch (Exception e) {
                logger.error("\u7ec4\u4ef6\u6ce8\u518c\u5931\u8d25: {}", (Object)e.getMessage());
            }
        });
        TConnPool.getDefaultPool().releaseConnection(conn);
    }

    private void registerComponent(CpnConfMasterDao dao, RouteCpnRegister annotation) {
        CpnConfMaster existing = dao.selectById(annotation.cpnId());
        if (existing == null) {
            CpnConfMaster newCpn = this.createCpnConfMaster(annotation);
            dao.insert(newCpn);
            logger.info("\u65b0\u589e\u7ec4\u4ef6\u6ce8\u518c\u6210\u529f: {} - {}", (Object)annotation.cpnId(), (Object)annotation.cpnName());
        } else if (this.compareVersion(annotation.cpnVersion(), existing.getCpnVersion()) > 0) {
            String cpnId = this.generateRandomPrimaryKey(6);
            CpnConfMaster updatedCpn = this.createCpnConfMaster(annotation);
            updatedCpn.setCpnState("1");
            updatedCpn.setCpnId(cpnId);
            dao.insert(updatedCpn);
            logger.info("\u7ec4\u4ef6\u66f4\u65b0\u6210\u529f: {} - {} (\u7248\u672c {} -> {})", new Object[]{annotation.cpnId(), annotation.cpnName(), existing.getCpnVersion(), annotation.cpnVersion()});
        } else if (this.compareVersion(annotation.cpnVersion(), existing.getCpnVersion()) < 0) {
            logger.warn("\u7ec4\u4ef6\u7248\u672c\u4f4e\u4e8e\u6570\u636e\u5e93\u7248\u672c: {} - {} (\u5f53\u524d:{} \u6570\u636e\u5e93:{})", new Object[]{annotation.cpnId(), annotation.cpnName(), annotation.cpnVersion(), existing.getCpnVersion()});
        } else {
            logger.debug("\u7ec4\u4ef6\u7248\u672c\u4e00\u81f4\u65e0\u9700\u66f4\u65b0: {} - {}", (Object)annotation.cpnId(), (Object)annotation.cpnName());
        }
    }

    private CpnConfMaster createCpnConfMaster(RouteCpnRegister annotation) {
        CpnConfMaster cpn = new CpnConfMaster();
        cpn.setCpnId(annotation.cpnId());
        cpn.setCpnCode(annotation.cpnCode());
        cpn.setCpnName(annotation.cpnName());
        cpn.setCpnCategory(annotation.cpnCategory());
        cpn.setCpnType(annotation.cpnType());
        cpn.setCpnVersion(annotation.cpnVersion());
        cpn.setCpnClass(annotation.cpnClass());
        cpn.setCpnConfigUrl(annotation.cpnConfigUrl());
        cpn.setOwnerBizLine(annotation.ownerBizLine());
        cpn.setOwnerBizType(annotation.ownerBizType());
        cpn.setOwnerBizProduct(annotation.ownerBizProduct());
        cpn.setCpnState(annotation.cpnState());
        cpn.setCreateUser(annotation.createUser());
        cpn.setCreateTime(annotation.createTime());
        cpn.setUpdateUser(annotation.updateUser());
        cpn.setCpnRemarks(annotation.cpnRemarks());
        return cpn;
    }

    private int compareVersion(String version1, String version2) {
        if (Objects.equals(version1, version2)) {
            return 0;
        }
        String[] v1Parts = version1.split("\\.");
        String[] v2Parts = version2.split("\\.");
        for (int i = 0; i < Math.max(v1Parts.length, v2Parts.length); ++i) {
            int v2;
            int v1 = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2 = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1 == v2) continue;
            return v1 - v2;
        }
        return 0;
    }

    public String generateRandomPrimaryKey(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("\u4e3b\u952e\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0");
        }
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder(6);
        for (int i = 0; i < length; ++i) {
            int index = (int)(Math.random() * (double)chars.length());
            sb.append(chars.charAt(index));
        }
        return sb.toString();
    }
}

