/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinflow.executor.application.executor.rest.utils.AnsiLog;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ConnPoolForDruid
implements IConnPool {
    private DruidDataSource druidDataSource;

    public ConnPoolForDruid() {
        try {
            this.druidDataSource = (DruidDataSource)SpringContextUtils.getBean((String)"druidDataSource");
        }
        catch (NoSuchBeanDefinitionException e) {
            this.druidDataSource = (DruidDataSource)SpringContextUtils.getBean((String)"dataSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        AnsiLog.info("\u6570\u636e\u6e90\u6d3b\u52a8\u7684\u8fde\u63a5\u6570ActiveCount:" + this.druidDataSource.getActiveCount());
        Set conns = this.druidDataSource.getActiveConnections();
        List list = this.druidDataSource.getActiveConnectionStackTrace();
        for (String string : list) {
            AnsiLog.info("ActiveConnectionStackTrace:" + string);
        }
        for (DruidPooledConnection conn : conns) {
            AnsiLog.info("ActiveConnections\uff1a" + conn.getConnectStackTrace());
        }
        DruidDataSource druidDataSource = this.druidDataSource;
        synchronized (druidDataSource) {
            return this.druidDataSource.getConnection();
        }
    }

    @Override
    public int getConnectionCount() {
        return (int)this.druidDataSource.getConnectCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(Connection conn) {
        DruidDataSource druidDataSource = this.druidDataSource;
        synchronized (druidDataSource) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void clearAndFree() {
        this.druidDataSource.close();
    }
}

