/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.application.service.impl;

import com.irdstudio.allinflow.executor.application.executor.core.batch.AprFlowEngineApplication;
import com.irdstudio.allinflow.executor.facade.AprFlowEngineFacade;
import com.irdstudio.allinflow.executor.facade.dto.ResponseDTO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AprFlowEngineServiceImpl")
public class AprFlowEngineServiceImpl
implements AprFlowEngineFacade {
    private static Logger logger = LoggerFactory.getLogger(AprFlowEngineServiceImpl.class);

    public ResponseDTO flowActionHandler(String action, String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        ResponseDTO vo = new ResponseDTO();
        try {
            logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u5f00\u59cb, \u5ba1\u6279\u6d41\u7a0bID\uff1a" + batchId + ", \u5ba1\u6279\u6d41\u7a0b\u52a8\u4f5c\uff1a" + action);
            AprFlowEngineApplication batchEngine = new AprFlowEngineApplication(batchSerialNo, action, batchId, envId, param);
            batchEngine.start();
            vo.setFlag("success");
            vo.setMsg("\u6210\u529f\u6267\u884c\u5ba1\u6279\u6d41\u7a0b");
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
            vo.setFlag("fail");
            vo.setMsg("\u6267\u884c\u5ba1\u6279\u6d41\u7a0b\u5f02\u5e38");
        }
        logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u8c03\u7528\u7ed3\u675f");
        return vo;
    }

    public ResponseDTO startFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("run", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO continueFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("continue", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO resumeFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("resume", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO rollBackFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("rollBack", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO returnFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("return", batchSerialNo, batchId, envId, param);
    }

    public ResponseDTO abortFlow(String batchSerialNo, String batchId, String envId, Map<String, Object> param) {
        return this.flowActionHandler("abort", batchSerialNo, batchId, envId, param);
    }
}

