/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.executor.web.controller.api;

import com.irdstudio.allinflow.executor.facade.TaskFlowEngineService;
import com.irdstudio.allinflow.executor.facade.dto.FlowInstTaskDTO;
import com.irdstudio.allinflow.executor.facade.dto.FlowNodeUsrDTO;
import com.irdstudio.allinflow.executor.facade.dto.FlowTskInfoDTO;
import com.irdstudio.allinflow.executor.types.HandOpType;
import com.irdstudio.allinflow.executor.web.controller.util.CheckUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TaskFlowEngineController
extends AbstractController {
    @Autowired
    private TaskFlowEngineService taskFlowEngineService;

    @RequestMapping(value={"/client/TaskFlowEngineService/tskHandle"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowInstTaskDTO> tskHandle(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u64cd\u4f5c\u7c7b\u578b\u5fc5\u8f93", flowInstTaskDTO.getOpType());
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
            CheckUtil.check("\u4efb\u52a1\u6d41\u6c34\u53f7\u5fc5\u8f93", flowInstTaskDTO.getTskSeqNo());
            if (HandOpType.TOP.getCode().equals(flowInstTaskDTO.getOpType()) || HandOpType.URGENT.getCode().equals(flowInstTaskDTO.getOpType())) {
                CheckUtil.check("\u662f\u5426\u6807\u8bc6\u5fc5\u8f93", flowInstTaskDTO.getIsFlag());
            }
            if (HandOpType.SUBMIT.getCode().equals(flowInstTaskDTO.getOpType())) {
                CheckUtil.check("\u5904\u7406\u610f\u89c1\u5fc5\u8f93", flowInstTaskDTO.getHandMessage());
                CheckUtil.check("\u5904\u7406\u7ed3\u8bba\u5fc5\u8f93", flowInstTaskDTO.getProcConcl());
            }
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.tskHandle(flowInstTaskDTO);
    }

    @RequestMapping(value={"/client/TaskFlowEngineService/tskAssRect"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowInstTaskDTO> tskAssRect(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u64cd\u4f5c\u7c7b\u578b\u5fc5\u8f93", flowInstTaskDTO.getOpType());
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
            CheckUtil.check("\u5904\u7406\u4eba\u5fc5\u8f93", flowInstTaskDTO.getOprr());
            CheckUtil.check("\u5904\u7406\u4eba\u673a\u6784\u5fc5\u8f93", flowInstTaskDTO.getOprrBelgOrg());
            if (flowInstTaskDTO.getTskInfo() == null || flowInstTaskDTO.getTskInfo().isEmpty()) {
                throw new RuntimeException("\u4efb\u52a1\u4fe1\u606f");
            }
            CheckUtil.check("\u4efb\u52a1\u6d41\u6c34\u53f7\u5fc5\u8f93", ((FlowTskInfoDTO)flowInstTaskDTO.getTskInfo().get(0)).getTskSeqNo());
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.tskAssRect(flowInstTaskDTO);
    }

    @RequestMapping(value={"/client/TaskFlowEngineService/qryTaskList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowInstTaskDTO>> qryTaskList(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u67e5\u8be2\u7c7b\u578b\u5fc5\u8f93", flowInstTaskDTO.getQryType());
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.qryTaskList(flowInstTaskDTO);
    }

    @RequestMapping(value={"/client/TaskFlowEngineService/qryRetInfoList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<FlowNodeUsrDTO>> qryRetInfoList(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u4efb\u52a1\u6d41\u6c34\u53f7", flowInstTaskDTO.getTskSeqNo());
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.qryRetInfoList(flowInstTaskDTO);
    }

    @RequestMapping(value={"/client/TaskFlowEngineService/tskCreated"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowInstTaskDTO> tskCreated(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
            CheckUtil.check("\u4efb\u52a1\u7c7b\u578b", flowInstTaskDTO.getTskTp());
            CheckUtil.check("\u4e1a\u52a1\u6d41\u6c34\u53f7\u5fc5\u8f93", flowInstTaskDTO.getBizSeqNo());
            CheckUtil.check("\u5ba2\u6237\u7f16\u53f7\u5fc5\u8f93", flowInstTaskDTO.getCustNo());
            CheckUtil.check("\u5ba2\u6237\u540d\u79f0\u5fc5\u8f93", flowInstTaskDTO.getCustName());
            CheckUtil.check("\u4ea7\u54c1\u7f16\u53f7\u5fc5\u8f93", flowInstTaskDTO.getPrdCode());
            CheckUtil.check("\u4ea7\u54c1\u540d\u79f0\u5fc5\u8f93", flowInstTaskDTO.getPrdName());
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.tskCreated(flowInstTaskDTO);
    }

    @RequestMapping(value={"/client/TaskFlowEngineService/tskDetailsQry"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<FlowInstTaskDTO> tskDetailsQry(@RequestBody FlowInstTaskDTO flowInstTaskDTO) {
        this.setUserInfoToVO(flowInstTaskDTO);
        try {
            CheckUtil.check("\u767b\u5f55\u4ebaID\u5fc5\u8f93", flowInstTaskDTO.getLoginUserId());
            if (StringUtils.isBlank((String)flowInstTaskDTO.getTskSeqNo())) {
                CheckUtil.check("\u4efb\u52a1\u7c7b\u578b\u5fc5\u8f93", flowInstTaskDTO.getTskTp());
                CheckUtil.check("\u4e1a\u52a1\u6d41\u6c34\u53f7\u5fc5\u8f93", flowInstTaskDTO.getBizSeqNo());
            }
        }
        catch (RuntimeException e) {
            return ResponseData.create(null, (String)"999999", (String)e.getMessage(), (boolean)true);
        }
        return this.taskFlowEngineService.tskDetailsQry(flowInstTaskDTO);
    }
}

