/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.admin.api.rest;

import com.irdstudio.framework.beans.admin.service.facade.SDicService;
import com.irdstudio.framework.beans.admin.service.vo.SDicVO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SDicController
extends AbstractController {
    @Autowired
    @Qualifier(value="sDicService")
    private SDicService sDicService;
    private static ConcurrentMap<String, Object> cachedDic = new ConcurrentHashMap<String, Object>();

    @RequestMapping(value={"/s/dics"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SDicVO>> querySDicAll(SDicVO vo) {
        List<SDicVO> outputVo = this.sDicService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/dic/{enname}/{opttype}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SDicVO> queryByPk(@PathVariable(value="enname") String enname, @PathVariable(value="opttype") String opttype) {
        SDicVO inVo = new SDicVO();
        inVo.setEnname(enname);
        inVo.setOpttype(opttype);
        SDicVO outputVo = this.sDicService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SDicVO inSDicVo) {
        int outputVo = this.sDicService.deleteByPk(inSDicVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SDicVO inSDicVo) {
        int outputVo = this.sDicService.updateByPk(inSDicVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSDic(@RequestBody SDicVO inSDicVo) {
        int outputVo = this.sDicService.insertSDic(inSDicVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/dics/cache"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, List<SDicVO>>> queryCachedSDicAll(@RequestBody SDicVO vo) {
        if (StringUtils.contains((CharSequence)vo.getOpttype(), (CharSequence)",")) {
            String[] opttypes = StringUtils.split((String)vo.getOpttype(), (String)",");
            vo.setOpttypes(Arrays.asList(opttypes));
            vo.setOpttype(null);
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        if (StringUtils.isNotBlank((CharSequence)vo.getOpttype())) {
            if (cachedDic.get(vo.getOpttype()) == null) {
                List<SDicVO> outputVo = this.sDicService.queryAllOwner(vo);
                cachedDic.put(vo.getOpttype(), outputVo);
            }
            result.put(vo.getOpttype(), (List)cachedDic.get(vo.getOpttype()));
            return this.getResponseData(result);
        }
        if (CollectionUtils.isNotEmpty(vo.getOpttypes())) {
            ArrayList<String> newOpttypes = new ArrayList<String>(vo.getOpttypes().size());
            for (String opttype : vo.getOpttypes()) {
                if (cachedDic.get(opttype) != null) {
                    result.put(opttype, (List)cachedDic.get(opttype));
                    continue;
                }
                newOpttypes.add(opttype);
            }
            if (CollectionUtils.isNotEmpty(newOpttypes)) {
                vo.setOpttypes(newOpttypes);
                List<SDicVO> outputVo = this.sDicService.queryAllOwner(vo);
                if (CollectionUtils.isNotEmpty(outputVo)) {
                    HashMap<String, ArrayList<SDicVO>> newMap = new HashMap<String, ArrayList<SDicVO>>();
                    for (SDicVO dic : outputVo) {
                        ArrayList<SDicVO> list = (ArrayList<SDicVO>)newMap.get(dic.getOpttype());
                        if (list == null) {
                            list = new ArrayList<SDicVO>();
                            newMap.put(dic.getOpttype(), list);
                        }
                        list.add(dic);
                    }
                    cachedDic.putAll(newMap);
                    result.putAll(newMap);
                }
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(MapUtils.EMPTY_MAP);
    }
}

