/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.admin.api.rest;

import com.irdstudio.framework.beans.admin.service.facade.SRolerightService;
import com.irdstudio.framework.beans.admin.service.vo.SResourceRightTree;
import com.irdstudio.framework.beans.admin.service.vo.SRolerightVO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SRolerightController
extends AbstractController {
    @Autowired
    @Qualifier(value="sRolerightServiceImpl")
    private SRolerightService sRolerightService;

    @RequestMapping(value={"/s/rolerights"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRolerightVO>> querySRolerightAll(SRolerightVO vo) {
        List<SRolerightVO> outputVo = this.sRolerightService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleright/{roleno}/{resourceid}/{actid}/{orgid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SRolerightVO> queryByPk(@PathVariable(value="roleno") String roleno, @PathVariable(value="resourceid") String resourceid, @PathVariable(value="orgid") String orgid) {
        SRolerightVO inVo = new SRolerightVO();
        inVo.setRoleno(roleno);
        inVo.setResourceid(resourceid);
        inVo.setOrgid(orgid);
        SRolerightVO outputVo = this.sRolerightService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/roleright"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SRolerightVO inSRolerightVo) {
        int outputVo = this.sRolerightService.deleteByPk(inSRolerightVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleright"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SRolerightVO inSRolerightVo) {
        int outputVo = this.sRolerightService.updateByPk(inSRolerightVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleright"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSRoleright(@RequestBody SRolerightVO inSRolerightVo) {
        int outputVo = this.sRolerightService.insertSRoleright(inSRolerightVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role/rights/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRolerightVO>> qrySRoleRightAll(SRolerightVO vo) {
        List<SRolerightVO> outputVo = this.sRolerightService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role/right/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSRoleRight(@RequestBody SRolerightVO vo) {
        int outputVo = this.sRolerightService.saveSRoleRight(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role/right/save/{roleno}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSRoleRightTree(@RequestBody List<SResourceRightTree> tree, @PathVariable(value="roleno") String roleno) {
        int outputVo = this.sRolerightService.saveSRoleRightTree(tree, roleno);
        return this.getResponseData(outputVo);
    }
}

