/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.admin.service.impl;

import com.irdstudio.framework.beans.admin.dao.SUserDao;
import com.irdstudio.framework.beans.admin.dao.domain.SUser;
import com.irdstudio.framework.beans.admin.service.facade.SUserService;
import com.irdstudio.framework.beans.admin.service.vo.SUserVO;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import com.irdstudio.framework.beans.core.util.MD5Util;
import com.irdstudio.framework.beans.core.util.TimeUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sUserServiceImpl")
public class SUserServiceImpl
implements SUserService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SUserServiceImpl.class);
    @Autowired
    private SUserDao sUserDao;

    @Override
    public int insertSUser(SUserVO inSUserVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSUserVo.toString());
        int num = 0;
        try {
            SUser sUser = new SUser();
            this.beanCopy((Object)inSUserVo, (Object)sUser);
            sUser.setPassword(MD5Util.getMD5ofStr((String)(sUser.getActorno() + sUser.getActorno())));
            sUser.setCreater(inSUserVo.getLoginUserId());
            sUser.setCreattime(TimeUtil.getCurrentDateTime());
            num = this.sUserDao.insertSUser(sUser);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SUserVO inSUserVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inSUserVo));
        int num = 0;
        try {
            SUser sUser = new SUser();
            this.beanCopy((Object)inSUserVo, (Object)sUser);
            num = this.sUserDao.deleteByPk(sUser);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSUserVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SUserVO inSUserVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSUserVo.toString());
        int num = 0;
        try {
            SUser sUser = new SUser();
            this.beanCopy((Object)inSUserVo, (Object)sUser);
            num = this.sUserDao.updateByPk(sUser);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSUserVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public SUserVO queryByPk(SUserVO inSUserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inSUserVo));
        try {
            SUser querySUser = new SUser();
            this.beanCopy((Object)inSUserVo, (Object)querySUser);
            SUser queryRslSUser = this.sUserDao.queryByPk(querySUser);
            if (Objects.nonNull((Object)queryRslSUser)) {
                SUserVO outSUserVo = (SUserVO)((Object)this.beanCopy((Object)queryRslSUser, (Object)new SUserVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSUserVo.toString());
                return outSUserVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SUserVO> queryAllOwner(SUserVO sUserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sUserVo.toString());
        List list = null;
        try {
            List<SUser> sUsers = this.sUserDao.queryAllOwnerByPage(sUserVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sUsers.size());
            this.pageSet(sUsers, sUserVo);
            list = this.beansCopy(sUsers, SUserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SUserVO> queryAllCurrOrg(SUserVO sUserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sUserVo.toString());
        List<SUser> sUsers = this.sUserDao.queryAllCurrOrgByPage(sUserVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sUsers.size());
        List list = null;
        try {
            this.pageSet(sUsers, sUserVo);
            list = this.beansCopy(sUsers, SUserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SUserVO> queryAllCurrDownOrg(SUserVO sUserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sUserVo.toString());
        List<SUser> sUsers = this.sUserDao.queryAllCurrDownOrgByPage(sUserVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sUsers.size());
        List list = null;
        try {
            this.pageSet(sUsers, sUserVo);
            list = this.beansCopy(sUsers, SUserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int pwdByPk(SUserVO inSUserVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSUserVo.toString());
        int num = 0;
        try {
            SUser sUser = new SUser();
            this.beanCopy((Object)inSUserVo, (Object)sUser);
            sUser.setPassword(MD5Util.getMD5ofStr((String)(sUser.getActorno() + sUser.getActorno())));
            num += this.sUserDao.pwdByPk(sUser);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSUserVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }
}

