(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    const OFFSET_WINDOW_TOP = 140 ;

    const BASE_API = "https://allincloud.irdstudio.com"

    // 默认展示通讯员
    exports.ChoseDisplaySystem = {
        props: ['signUserId', 'modelValue'],
        data(){
            return {

                formData: {
                    actorno: this.signUserId,
                    defaultDisplay: '',
                },

                moduleList: [], // 模块
                collectList: [], // 收藏
                usageList: [], // 最近

                windowHeight: 0,

                searchStr: "", // 搜索

                activeGroup: 'usage', // 激活的分组
                collapseGroup: true, // 收起分组
                clickScrolling: false, // 标识是点击滚动的
            }
        },
        emits: ['update:modelValue'],
        watch: {
            value(val) {
                if (val) {
                    this.queryList();
                }
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            searchModule(e) {
                const self = this;
                const  { moduleList , searchStr} = self;
                if (searchStr) {
                    moduleList.forEach(el=>{
                        el.serachHide = ! (
                            el.moduleCode.toLowerCase().indexOf(searchStr.toLowerCase()) >= 0
                            || el.moduleName.toLowerCase().indexOf(searchStr.toLowerCase()) >= 0
                        );
                    })
                }
            },
            controlShow(el, index) {
                const self = this;
                const { searchMode } = self;
                if (searchMode) {
                    return !el.serachHide
                } else {
                    return true;
                }
            },
            queryList() {
                const self = this;
                self.loading = true;

                const taskQueue = new TaskQueue();
                // 查询模块
                taskQueue.push(callback=>{
                    $.restfulPostForm(BASE_API + '/allincloud/api/s/module/infos/role/rights', {size: 1000}, function(data){
                        self.moduleList = data.rows;
                        callback(true)
                    }, function(e){
                        self.loading = false;
                        callback(false)
                    }, true);
                })
                // 查询 最近6条 收藏
                taskQueue.push(callback=>{
                    $.restfulPostForm(BASE_API + '/allincloud/api/s/module/shortcuts', {
                            size: 6, descOrder: 'shortcutOpTime',
                            shortcutUser: self.signUserId ,
                            shortcutType: '1'
                        },
                        function(data){
                            self.collectList = data.rows;
                            callback(true)
                        }, function(e){
                            self.loading = false;
                            callback(false)
                        }, true);
                })
                // 查询 最近6条 最近访问
                taskQueue.push(callback=>{
                    $.restfulPostForm(BASE_API + '/allincloud/api/s/module/shortcuts/usage', {
                            size: 6, descOrder: 'shortcutOpTime',
                            shortcutUser: self.signUserId ,
                            shortcutType: '2'
                        },
                        function(data){
                            self.usageList = data.rows;
                            callback(true)
                        }, function(e){
                            self.loading = false;
                            callback(false)
                        }, true);
                })
                // 查询当月的任务
                taskQueue.push(callback=>{
                    self.loading = false;

                })
                taskQueue.start()

            },
            selectModule(module) {
                const self = this ;
                // self.formData.defaultDisplay = module.moduleCode;
                // const jsonData = Vue.toRaw(self.formData);
                // $.restfulPut('/allincloud/api/s/user/profile', jsonData, function(data) {
                // }, function(e){
                //     ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                // }, true);
                self.value = false;
                setTimeout(function(){
                    if (module.accessRight == 'Y') {
                        self.recordModule(module); // 有权限则记录访问
                    }
                    self.$emit('select', Vue.toRaw(module))
                },200)


            },
            closeDrawer() {
                this.value = false;
            },
            showCollect(event) {
                this.collapseGroup = false;
            },
            cancelCollectModule(module) {
                // 取消收藏
                const self = this;
                $.restfulPostJson(BASE_API + '/allincloud/api/s/module/shortcut/cancel',  { moduleCode: module.moduleCode}, function(data){
                    if (data.rows > 0) {
                        const idx = self.collectList.findIndex(el=>el.moduleCode  === module.moduleCode)
                        if (idx >= 0) {
                            self.collectList.splice(idx, 1);
                        }
                    }
                }, function(e){

                }, true);
            },
            collectModule(module) {
                // 收藏
                const self = this;
                $.restfulPostJson(BASE_API + '/allincloud/api/s/module/shortcut',  { moduleCode: module.moduleCode, shortcutType: '1' }, function(data){
                    if (data.rows > 0) {
                        self.collectList.push({ moduleCode: module.moduleCode, shortcutType: '1' })
                    }
                }, function(e){

                }, true);
            },
            recordModule(module) {
                // 记录经常访问
                const self = this;
                $.restfulPostJson(BASE_API + '/allincloud/api/s/module/shortcut',  { moduleCode: module.moduleCode, shortcutType: '2' }, function(data){
                    if (data.rows > 0) {
                        // self.usageList.splice(0, 1);
                        // self.usageList.push({ moduleCode: module.moduleCode, shortcutType: '1' })
                    }
                }, function(e){

                }, true);
            },
            getWindowSize: _.debounce(function() {
                let height = window.innerHeight ;
                this.windowHeight = height - 50 ;

            }, 150),
            scrollTo(item) {
                const self = this;
                // 获取目标的 offsetTop
                // css选择器是从 1 开始计数，我们是从 0 开始，所以要 +1
                const navContents = document.querySelectorAll(`.chose-display-container .chose-display-group-title`);
                let targetElem = null;
                for(let i=0; i<navContents.length; i++){ // 找到分组的锚点
                    const el = navContents[i]
                    let group = $(el).attr('anchor-id');
                    if (group == item.enname) {
                        targetElem = el;
                        break
                    }
                }
                if (!targetElem || !self.$refs.groupScrollRef) return;
                self.clickScrolling = true;
                self.activeGroup = $(targetElem).attr('anchor-id');
                const scrollTop = self.$refs.groupScrollRef.wrapRef.scrollTop;
                const elTop = $(targetElem).offset().top;
                if (  elTop < OFFSET_WINDOW_TOP ) {
                    // 向上 减
                    self.$refs.groupScrollRef.setScrollTop(scrollTop - Math.abs(elTop) + OFFSET_WINDOW_TOP)
                } else {
                    // 向下 加
                    self.$refs.groupScrollRef.setScrollTop(scrollTop + elTop - OFFSET_WINDOW_TOP)
                }
                setTimeout(()=>{
                    self.clickScrolling = false;
                }, 200)

            },
            onScroll: _.throttle(function() {
                const self =   this;
                if (self.clickScrolling) {
                    return;
                }

                const scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
                if (this.$el.previousSibling
                    && this.$el.previousSibling.getBoundingClientRect) {
                    this.fixedTopBtn = this.$el.previousSibling.getBoundingClientRect().bottom < 10 ;
                } else {
                    this.fixedTopBtn = this.$el.getBoundingClientRect().bottom < 10 ;
                }

                // 获取所有锚点元素
                const navContents = document.querySelectorAll(`.chose-display-container .chose-display-group-title`);

                const navLength = navContents.length
                for (let i=0; i<navLength; i++) {
                    const item = navContents[i]
                    const navIdx = i
                    if (!item.offsetParent || item.getBoundingClientRect().bottom == 0) {
                        // 当前页面没有显示
                        continue
                    }
                    let group = $(item).attr('anchor-id');
                    if (group) {
                        let rect = item.offsetParent.getBoundingClientRect();
                        if ((rect.top >= OFFSET_WINDOW_TOP && rect.bottom >= OFFSET_WINDOW_TOP) ||
                            (rect.top < OFFSET_WINDOW_TOP && rect.bottom >= OFFSET_WINDOW_TOP)) {
                            self.activeGroup  = group;
                            break;
                        }

                    }
                }

            }, 500),
        },
        provide() {
            return {
            }
        },
        computed: {

            searchMode() {
                const { searchStr } = this;
                return searchStr && searchStr.length > 1
            },
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            DIC() {
                return {
                    MODULE_GROUP: window.MODULE_GROUP || [],
                }
            },

            breadcrumb() {
                return ['产品与服务' ];

            },
            moduleMap() {
                const self = this;
                const { moduleList } = self;
                let map = {} ;
                if (moduleList) {
                    moduleList.forEach(el=>{
                        map[el.moduleCode] = el;
                    })
                }
                return map;
            },
        },
        unmounted() {
            $(window).on('resize', this.getWindowSize)
        },
        mounted() {
            let self = this;

            $(window).on('resize', self.getWindowSize)
            self.getWindowSize();
            self.queryList();

            window.choseInst = this;
        },
        template: `
        <el-drawer v-model="value" direction="ltr" :modal="false" append-to-body :with-header="false" size="65%" 
            modal-class="chose-display-modal"
            style="--el-drawer-padding-primary: 0px; ">
            <template #default>
                <div class="chose-display-container">
                     <el-row :style="{ height: windowHeight }">
                        <el-col :span="4" style="border-right: 1px solid var(--el-border-color-light);" >
                            <el-scrollbar >
                                <div class="chose-display-menu" @click="showCollect">
                                    <el-icon><i class="iconfont icon-pingfen"></i></el-icon>
                                    <span>我的收藏</span>
                                </div>
                                <div class="chose-display-menu" @click="()=>collapseGroup = true">
                                    <el-icon><i class="iconfont icon-gonggeshitu"></i></el-icon>
                                    <span>所有服务</span>
                                </div>
                                <ul class="chose-display-menu-ul" v-show="collapseGroup">
                                    <li class="chose-display-menu-ul-li" nav-id="usage" :nav-text="最近访问" :class="{ active: 'usage' === activeGroup }" 
                                      @click="scrollTo({enname: 'usage', cnname: '最近访问'}, $event)"
                                        >最近访问</li>
                                <template v-for="(el,index) in DIC.MODULE_GROUP">
                                    <li class="chose-display-menu-ul-li"  :key="index" 
                                        :nav-id="el.enname" :nav-text="el.cnname"
                                        :class="{ active: el.enname === activeGroup }"
                                        @click="scrollTo(el, $event)"
                                        >{{ el.cnname }}</li>
                                </template>
                                </ul>
                            </el-scrollbar>
                        </el-col> 
                        <el-col :span="20" v-show="collapseGroup">
                            <div style="display: flex; justify-content: space-between; padding: 20px 10px 10px 40px; ">
                                <el-input v-model="searchStr" size="large" placeholder="搜索服务" 
                                    style="width: 50%; "
                                    @keydown.enter="searchModule" @change="searchModule" prefix-icon="Search"></el-input>
                                <el-button icon="Close" size="large" text @click="closeDrawer" ></el-button>
                            </div>
                            <el-scrollbar ref="groupScrollRef" @scroll="onScroll" :style="{ height: windowHeight - 70 }">
                                <div class="chose-display-group"  >
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title" anchor-id="usage" anchor-text="最近访问">最近访问</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="12" v-for="(m, mIdx) in usageList.map(el=>moduleMap[el.moduleCode]).filter(controlShow)" :key="mIdx">
                                            <div class="chose-display-item" @click="selectModule(m)" 
                                                :class="{ 'chose-display-item-selected' : m.moduleCode === formData.defaultDisplay }" 
                                            >
                                                <div class="chose-display-item-name" style="flex: 0; padding-left: 0;padding-top:5px">
                                                    <span>{{m.moduleName}}</span>
                                                    <el-icon v-if="collectList.findIndex(el=>el.moduleCode === m.moduleCode ) >= 0 " @click.stop.prevent="cancelCollectModule(m)" > <i class="iconfont icon-pingfen" style="color: var(--el-color-warning);" ></i> </el-icon>
                                                    <el-icon v-if="collectList.findIndex(el=>el.moduleCode === m.moduleCode ) < 0 " class="chose-display-item-collect-icon" @click.stop.prevent="collectModule(m)" > <i class="iconfont icon-pingfen" style="color:  #999;" ></i> </el-icon>
                                                </div>
                                                <div class="chose-display-item-desc">
                                                    <div class="li-spanName" >{{m.moduleDesc}}</div>
                                                </div>
                                            </div>
                                        </el-col>
                                    </el-row>
                                </div>
                                <template v-for="(group, index) in DIC.MODULE_GROUP" >
                                <div class="chose-display-group"  :key="index" v-if="moduleList.filter(m=>m.moduleGroup==group.enname ).filter(controlShow).length > 0">
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title"
                                                :anchor-id="group.enname" :anchor-text="group.cnname"
                                                >{{group.cnname}}</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="12" v-for="(m, mIdx) in moduleList.filter(m=>m.moduleGroup==group.enname ).filter(controlShow)" :key="mIdx">
                                            <div class="chose-display-item" @click="selectModule(m)" 
                                                :class="{ 'chose-display-item-selected' : m.moduleCode === formData.defaultDisplay }" 
                                            >
                                                <div class="chose-display-item-name" style="flex: 0; padding-left: 0;padding-top:5px">
                                                    <span>{{m.moduleName}}</span>
                                                    <el-icon v-if="collectList.findIndex(el=>el.moduleCode === m.moduleCode ) >= 0 " @click.stop.prevent="cancelCollectModule(m)" > <i class="iconfont icon-pingfen" style="color: var(--el-color-warning);" ></i> </el-icon>
                                                    <el-icon v-if="collectList.findIndex(el=>el.moduleCode === m.moduleCode ) < 0 " class="chose-display-item-collect-icon" @click.stop.prevent="collectModule(m)" > <i class="iconfont icon-pingfen" style="color:  #999;" ></i> </el-icon>
                                                </div>
                                                <div class="chose-display-item-desc">
                                                    <div class="li-spanName" >{{m.moduleDesc}}</div>
                                                </div>
                                            </div>
                                        </el-col>
                                    </el-row>
                                </div>
                                </template>
                            </el-scrollbar>
                        </el-col> 
                        <el-col :span="18" v-show="!collapseGroup">
                            <el-scrollbar >
                                <div class="chose-display-group"  >
                                    <el-row style="padding-top: 0px;" >
                                        <el-col style="display:flex;">
                                            <div class="chose-display-group-title">我的收藏</div>
                                        </el-col>
                                    </el-row>
                                    <el-row :gutter="10">
                                        <el-col :span="12" v-for="(m, mIdx) in collectList.map(el=>moduleMap[el.moduleCode])" :key="mIdx">
                                            <div class="chose-display-item" @click="selectModule(m)" 
                                                :class="{ 'chose-display-item-selected' : m.moduleCode === formData.defaultDisplay }" 
                                            >
                                                <div class="chose-display-item-name" style="flex: 0; padding-left: 0;padding-top:5px">
                                                    <span>{{m.moduleName}}</span>
                                                    <el-icon > <i class="iconfont icon-pingfen" style="color: #999;" ></i> </el-icon>
                                                </div>
                                                <div class="chose-display-item-desc">
                                                    <div class="li-spanName" >{{m.moduleDesc}}</div>
                                                </div>
                                            </div>
                                        </el-col>
                                    </el-row>
                                </div>
                            </el-scrollbar>
                        </el-col> 
                    </el-row>
                </div>
                
            </template>
        </el-drawer>
        `
    }

}));