// 针对EASYUI进行扩展的辅助类，用于更简捷的操作EASYUI
var JLEUtil = JLEUtil || {};
var win = undefined;
(function(jQuery) {

	/**
	 * <p>
	 * <ul>提供基于iframe的dialog实现，保证引入页面的可用性</ul>
	 * </p>
	 * <ul>将iframe的高度改为99%，防止重复出现滚动条问题</ul>
	 * <ul>如果要顶层打开窗口，请使用top.JLEUtil.createwin</ul>
	 * @param options为配置参数对象{id:id,title:'标题',url:'url地址',width:800,height:300,modal:true,draggable:true,resizable:true,maximized:false,maximizable：true,toolbar}
	 * 参考dialog属性和方法
	 * id:唯一标识
	 * title:弹出窗口的标题
	 * url:弹出窗口的内容
	 * width:窗口宽度，默认600
	 * height:窗口高度，默认300
	 * modal:是否模态窗口,默认true
	 * draggable:是否可拖动，默认true
	 * resizable:是否可改变大小，默认false
	 * maximized:是否以最大化窗口的方式打开，默认true
	 * maximizable:是否有最大化窗口的按钮
	 * toolbar:工具栏
	 */
	JLEUtil.createwin=function(options) {
		var top = $(window).scrollTop();
		var opts=$.extend({
			width : 600,
			height : 300,
			modal:true,
			maximized:false,
			maximizable:true,
			onClose : function() {
				$(win).parent().removeClass('fixed-current-dialog')
				if (window.parent && !window.parent.win) {
					window.parent.win = $(window.parent.document).find('.top-dialog')[0]
				}
				let parentWin = window.parent.win
				// 父级窗口是top
				if (window.parent == window.top && Array.isArray(parentWin)) {
					parentWin = !!parentWin[parentWin.length - 1] ?  parentWin[parentWin.length - 1][0] :window ;
				}
				$(parentWin).removeClass('fixed-dialog-position')
				$('body').removeClass('fixed-dialog-body-overflow');
				let height = $(parentWin).height() + 27;
				$(parentWin).parent().css('height', height + 'px')
				$(this).dialog('destroy');
				win = undefined;
			}
		},options);
		if (options.url) {
			if (!(options.url.startsWith("http") || options.url.startsWith("/"))) {
				// options.url =
			}
			opts.content = '<iframe id="" src="" allowTransparency="true" fit="true" scrolling="auto" width="100%" height="99.5%" frameBorder="0" name=""></iframe>';
		}
		if (window.parent && !window.parent.win) {
			window.parent.win = $(window.parent.document).find('.top-dialog')[0]
		}
		let parentWin = window.parent.win
		if (opts.overParent && window.parent.win && parentWin) {
			// 父级窗口是top
			if (window.parent == window.top && Array.isArray(parentWin)) {
				parentWin = !!parentWin[parentWin.length - 1] ?  parentWin[parentWin.length - 1][0] :window ;
			}
			let width = $(parentWin).width();
			let height = $(parentWin).height();
			$(parentWin).addClass('fixed-dialog-position')
			$('body').addClass('fixed-dialog-body-overflow');
			if (!!parentWin[parentWin.length - 1]) options.height = height + 23 + 12
			$(parentWin).parent().css('height', options.height + 'px')
			setTimeout(function() {
				$(win).parent().addClass('fixed-current-dialog');
				$(win).parent().css('height', options.height + 'px');
				$(window.win).panel('resize', {
					width: width + 12,
					// height: options.height
				})
			}, 50)
		}
		win=$('<div/>');
		var dia = win.dialog(opts);
		var diaWin = dia.dialog('window');
		if(opts.maximized){
			//修正以最大化窗口的方式打开时，如果父页面出现滚动条时则引起打开窗口错位的问题
			diaWin.css('top',top);
		}
		dia.find("iframe").attr("src",options.url);
		/*******************修改弹出框中button按钮的样式，开始，添加于20140902*********************/
		dia.find('.dialog-button').addClass('new_btn').css("margin-top","-20px");
		/*******************修改弹出框中button按钮的样式，结束*********************/
		return dia;
	};

	JLEUtil.createTopWin=function(options) {
		var scrollTop = $(window).scrollTop();
		var query = top.$;
		var opts=$.extend({
			width : 800,
			height : 450,
			modal:true,
			maximized:false,
			maximizable:true,
			onClose : function() {
				query(this).dialog('destroy');
				if (top.$reloadTree) {
					top.reloadTree = top.$reloadTree
				}
				if (top.$reloadList) {
					top.reloadList = top.$reloadList
				}
			}
		},options);
		if (options.url) {
			opts.content = '<iframe id="" src="" allowTransparency="true" fit="true" scrolling="auto" width="100%" height="100%" frameBorder="0" name=""></iframe>';
		}
		//win=query('<div/>').appendTo('body').html(options.html);
		if (!top.win) {
			top.win = []
		}
		let localWin = query('<div class="top-dialog"/>').appendTo('body').html(options.html);
		top.win.push([localWin, window])
		localWin.dialog({width:options.width, height:options.height})
		localWin.window('center');
		var dia = localWin.dialog(opts);
		var diaWin = dia.dialog('window');
		if(opts.maximized){
			//修正以最大化窗口的方式打开时，如果父页面出现滚动条时则引起打开窗口错位的问题
			diaWin.css('top',scrollTop);
		}
		//重写top方法，使方法指向父页面
		// 判断当前页面是否为top，若是则不重写页面方法
		if(top.location!=window.location) {
			if (!top.reloadList) {
				top.reloadList = function () {
					if (top.win && Array.isArray(top.win)) {
						// array from top.win
						let localWindow = top.win[top.win.length - 1][1];
						if (localWindow.reloadList  && localWindow != top)localWindow.reloadList();
						top.JLEUtil.closewin();
					} else {
						//window.reloadList();
						top.JLEUtil.closewin();
					}
				}
			} else {
				top.$reloadList = top.reloadList;
				top.reloadList = function () {
					if (top.win && Array.isArray(top.win)) {
						// array from top.win
						let localWindow = top.win[top.win.length - 1][1];
						if (localWindow.reloadList  && localWindow != top)localWindow.reloadList();
						top.JLEUtil.closewin();
					} else {
						//window.reloadList();
						top.JLEUtil.closewin();
					}
				}
			}

			if (!top.reloadTree) {
				top.reloadTree = function(){
					if (top.win && Array.isArray(top.win)) {
						// array from top.win
						let localWindow = top.win[top.win.length -1][1];
						if (localWindow.reloadTree && localWindow != top)localWindow.reloadTree();
						top.JLEUtil.closewin();
					} else {
						//window.reloadTree();
						top.JLEUtil.closewin();
					}
				}
			} else {
				top.$reloadTree = top.reloadTree
				top.reloadTree = function(){
					if (top.win && Array.isArray(top.win)) {
						// array from top.win
						let localWindow = top.win[top.win.length -1][1];
						if (localWindow.reloadTree && localWindow != top)localWindow.reloadTree();
						top.JLEUtil.closewin();
					} else {
						//window.reloadTree();
						top.JLEUtil.closewin();
					}
				}
			}
		}

		dia.find("iframe").attr("src",options.url);
		// 修正iframe高度
		var dH = dia.height();
		dia.find("iframe").css('height', `${dH}px`);
		return dia;
	};

	JLEUtil.createTopModalWin=function(title,url) {
		var deep = top.location.pathname.substring(top.location.pathname.indexOf('page')).split('/').length - 2;
		if (deep >= 1 && !url.startsWith('../')&& !url.startsWith('/')) {
			let parent = '';
			for (let i=0; i<deep; i++) {
				parent += '../';
			}
			url = parent + url
		}
		var w = top.document.documentElement.offsetWidth || top.document.body.offsetWidth;
		var h = top.document.documentElement.offsetHeight || top.document.body.offsetHeight;
		var ob={title:title,url:url,width:parseInt(w*0.7),height:parseInt(h*0.7),draggable:false,modal:true};
		JLEUtil.createTopWin(ob);
	}
	JLEUtil.createTopFullModalWin=function(title,url) {
		var deep = top.location.pathname.substring(top.location.pathname.indexOf('page')).split('/').length - 2;
		if (deep >= 1 && !url.startsWith('../')&& !url.startsWith('/')) {
			let parent = '';
			for (let i=0; i<deep; i++) {
				parent += '../';
			}
			url = parent + url
		}
		var w = top.document.documentElement.offsetWidth || top.document.body.offsetWidth;
		var h = top.document.documentElement.offsetHeight || top.document.body.offsetHeight;
		var ob={title:title,url:url,width:parseInt(w*1),height:parseInt(h*1),draggable:false,modal:true};
		JLEUtil.createTopWin(ob);
	}

	JLEUtil.createModalWin=function(title,url) {
		var w = document.documentElement.offsetWidth || document.body.offsetWidth;
		var h = document.documentElement.offsetHeight || document.body.offsetHeight;
		var ob={title:title,url:url,width:parseInt(w*0.7),height:parseInt(h*0.7),draggable:false,modal:true};
		JLEUtil.createwin(ob);
	};
	JLEUtil.createModalWinCustomSize=function(title,url,width,height) {
		var w = document.documentElement.offsetWidth || document.body.offsetWidth;
		var h = document.documentElement.offsetHeight || document.body.offsetHeight;
		var ob={title:title,url:url,modal:true,width:parseInt(w*width),height:parseInt(h*height),draggable:false};
		JLEUtil.createwin(ob);
	};
	JLEUtil.createListModalWin=function(title,url) {
		var w = document.documentElement.offsetWidth || document.body.offsetWidth;
		var h = document.documentElement.offsetHeight || document.body.offsetHeight;
		var ob={title:title,url:url,modal:true,width:parseInt(w*1),height:parseInt(h*1),draggable:false};
		JLEUtil.createwin(ob);
	};
	JLEUtil.createFullModalWin=function(title,url) {
		var w = document.documentElement.offsetWidth || document.body.offsetWidth;
		var h = document.documentElement.offsetHeight || document.body.offsetHeight;
		var ob={title:title,url:url,modal:true,width:parseInt(w*1),height:parseInt(h*1),draggable:false, overParent: true};
		JLEUtil.createwin(ob);
	};
	JLEUtil.createInnerModalWinUp=function(title,url, offset=54) {
		if (!url.startsWith('/')) {
			url = '../' + url;
		}
		JLEUtil.createInnerModalWin(title, url, offset);
	}
	JLEUtil.createInnerModalWinUpThird=function(title,url, offset=54) {
		if (!url.startsWith('/')) {
			url = '../../' + url;
		}
		JLEUtil.createInnerModalWin(title, url, offset);
	}
	JLEUtil.createInnerModalWin=function(title,url, offset=54) {
		var options={title:title,url:url,draggable : false,modal : true,maximized : true, maximizable: false};
		var opts = $.extend({
			width : 850,
			height : 500,
			modal : true,
			maximized : true,
			maximizable : true,
			onClose : function() {
				$(this).dialog('destroy');
			}
		}, options);
		if (options.url) {
			opts.content = '<iframe id="" src="" allowTransparency="true" scrolling="auto" width="100%" height="100%" frameBorder="0" name=""></iframe>';
		}
		win = $('<div/>');
		var dia = win.dialog(opts);
		var diaWin = dia.dialog('window');
		//if (opts.maximized) {//不再判断窗口是否以最大化打开
		// 修正以最大化窗口的方式打开时，如果父页面出现滚动条时则引起打开窗口错位的问题
		diaWin.css('top', $(window).scrollTop());
		//}
		dia.find("iframe").attr("src", options.url);
		// 修正iframe高度
		var dH = dia.height();
		dia.find("iframe").css('height', `${dH - offset}px`);
		// 隐藏标题
		diaWin.find('.panel-title').css('position', 'relative').css('top', '-5px');
		return dia;
	};
	//创建领域变量窗口
	JLEUtil.createModalSelectWin=function(title,url) {
		var w = document.documentElement.offsetWidth || document.body.offsetWidth;
		var h = document.documentElement.offsetHeight || document.body.offsetHeight;
		var ob={title:title,url:url,width:parseInt(w*0.47),height:parseInt(h*0.85),draggable:false,modal:true};
		JLEUtil.createwin(ob);
	};


// 关闭打开的窗口
	JLEUtil.closewin=function(){
		try {
			if (win && Array.isArray(win)) {
				// array from top.win
				let localWin = win.pop()[0];
				localWin.dialog('close');
			} else {
				win.dialog('close');
			}
		} catch(e) {
			// 尝试通过触发 弹框右上角关闭按钮来关闭弹框
			let localJquery = window.$;
			let maxLoop = 10, i = 1;
			while(localJquery('.window-header .panel-tool-close').length == 0 && i <= maxLoop) {
				localJquery = window.parent.$;
				i++; // 避免进入死循环
			}
			localJquery('.window-header .panel-tool-close').click();
			//ignore
			console.error(e);
		}
	};

	// 提交保存数据的AJAX请求,callback不传则默认处理
	JLEUtil.doSaveRecord=function(formName,url,callback){
		var param = $('#' + formName).serialize();
		if(!callback){
			JLEUtil.doAjax(url,param,function(data){
				$.messager.alert("提示", '记录保存成功!');
				window.parent.JLEUtil.closewin();
			});
		} else {
			JLEUtil.doAjax(url,param,callback);
		}

	};

	// 提交AJAX请求操作,successCall为交易成功后处理函数,failureCall交易失败为失败默认处理,不传则默认处理
	JLEUtil.doAjax=function(url,param,successCall,failureCall){
		$.ajax({
			type: "POST",
			url: url,
			data: param,
			async:false,
			success: function(data) {
				try {
					var jsonstr = eval("("+data+")");
					var flag = jsonstr.ec;
					if(flag=='0'){
						if(!successCall){
							$.messager.alert("提示", '操作成功!');
						} else {
							successCall(data);
						}
						return true;
					}else{
						if(!failureCall){
							$.messager.alert("提示", jsonstr.em);
						} else {
							failureCall(data);
						}
						return false;
					}
				} catch(e) {
					$.messager.alert("提示", e);
					return false;
				}
			}
		});
	};

	// 根据指定form的条件与指定的datagrid及指定的URL进行查询
	JLEUtil.queryForm=function(formName,dgName,url){
		// var queryUrl = url.indexOf("?") > 0
		// 		? url + "&" + decodeURIComponent($('#' + formName).serialize(),true)
		// 		: url + "?" + decodeURIComponent($('#' + formName).serialize(),true);
		// $('#' + dgName).datagrid('options').url = queryUrl;
		$('#' + dgName).datagrid({
			url : url,
			queryParams: $('#' + formName).serializeJson()
		});
		setTimeout(function(){
			try{
				$('#searchPanel').panel('resize');
			} catch(e) {
				// ignore 没有错就错
			}
			$('#' + dgName).datagrid('resize');
		}, 50)
	};

	// 直接根据URL来进行查询数据
	JLEUtil.queryOnly=function(dgName,url){
		$('#' + dgName).datagrid('options').url = url;
		$('#' + dgName).datagrid('load');
	};

	// 清空(重置)指定form填写的内容
	JLEUtil.clearForm=function(formName){
		$('#' + formName).form('clear');
	};

	// 根据选项值得到选项描述
	JLEUtil.formatter_dict = function(value,dictObj){
		for(var i=0;i<dictObj.length;i++){
			if(value == dictObj[i].enname)
				return dictObj[i].cnname;
		}
	};

	JLEUtil.paramUrl2Obj = function(url) {
		var search = url.split('?')[1]
		if (!search) {
			return {}
		}
		return JSON.parse('{"' + decodeURIComponent(search).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g, '":"').replace(/\n/g, '\\n') + '"}')
	};
	JLEUtil.linkNewPage = function(title, url){
		var commonLinkObj = document.getElementById("commonLink");
		if(!commonLinkObj){
			commonLinkObj = document.createElement("a");
			commonLinkObj.target = "_blank";
		}
		commonLinkObj.href = url;
		commonLinkObj.click();
	},
		/**
		 * 应用操作按钮渲染展示函数
		 * group 分组
		 * dgName datagrid id
		 * maxBtn 最大显示按钮数 多于 maxBtn， 往后展示成下拉
		 */
		JLEUtil.formatterActionBtn = function(group, dgName, maxBtn=3, spanClass='', prefixText='') {
			return function(value, row, index) {
				if(row.actionList && row.actionList.length>0) {
					localStorage.setItem(row.appId, JSON.stringify(row));
					let menuCtx = null;
					return row.actionList.filter(function(el){ return el.actionGroup == group }).map(function(el, index, array){
						localStorage.setItem(row.appId+el.actionId, JSON.stringify(el));
						el.btnType = el.btnType || 'linkbutton'
						if (array.length > maxBtn) {
							if (index < maxBtn - 1) {
								return el.btnType == 'linkbutton' ? `<span class="button ${spanClass}"><a href="javascript:void(0)" class="easyui-linkbutton" onclick="JLEUtil.actionHandler(this, '${dgName}', '${row.appId}', '${el.actionId}')" iconCls="${el.actionIcon}" plain="true" >${prefixText}${el.actionName}</a></span>`
									: `<span class="button ${spanClass}"><a href='#' class='easyui-menubutton' data-options='menu:"#${el.menuId}"' onblur="setTargetSelect(this, '${dgName}')" appid='${row.appId}' plain='true' iconCls="${el.actionIcon}">${prefixText}${el.actionName}</a></span>`
							} else if (index == maxBtn - 1 ){
								// 折叠成下拉 更多操作
								let menuId = `mm${row.appId}`;
								$('body').find('#' + menuId).remove();
								menuCtx = $(`<div id="${menuId}" style="width:auto; display:none;"></div>`);
								$('body').append(menuCtx);
								$(menuCtx).append(
									el.btnType == 'linkbutton' ? `<div onclick="JLEUtil.actionHandler(this, '${dgName}', '${row.appId}', '${el.actionId}')" data-options="iconCls:'${el.actionIcon}'">${prefixText}${el.actionName}</div>`
									: `<div><span>${el.actionName}</span><div>${$('#' + el.menuId).html()}</div></div>`
								);
								return `<span class="button ${spanClass}"><a href='#' class='easyui-menubutton' data-options='menu:"#${menuId}"' onblur="setTargetSelect(this, '${dgName}')" appid='${row.appId}' plain='true' iconCls="iconfont icon-menu2">更多操作</a></span>`
							} else {
								// 追加到  menuCtx
								$(menuCtx).append(
									el.btnType == 'linkbutton' ?  `<div onclick="JLEUtil.actionHandler(this, '${dgName}', '${row.appId}', '${el.actionId}')" data-options="iconCls:'${el.actionIcon}'">${prefixText}${el.actionName}</div>`
										: `<div><span>${el.actionName}</span><div>${$('#' + el.menuId).html()}</div></div>`
								);
							}
						} else {
							return el.btnType == 'linkbutton' ? `<span class="button ${spanClass}"><a href="javascript:void(0)" class="easyui-linkbutton" onclick="JLEUtil.actionHandler(this, '${dgName}', '${row.appId}', '${el.actionId}')" iconCls="${el.actionIcon}" plain="true" >${prefixText}${el.actionName}</a></span>`
								: `<span class="button ${spanClass}"><a href='#' class='easyui-menubutton' data-options='menu:"#${el.menuId}"' onblur="setTargetSelect(this, '${dgName}')" appid='${row.appId}' plain='true' iconCls="${el.actionIcon}">${prefixText}${el.actionName}</a></span>`
						}

					}).join('');
				} else {
					return '';
				}
			}
		}
	var actionDialogMap = {
		'0' : "JLEUtil.linkNewPage", //新标签
		'1' : "JLEUtil.createTopFullModalWin", //页面全屏
		'2' : "JLEUtil.createInnerModalWin", //标签全屏
		'3' : "JLEUtil.createTopModalWin", //中屏
		'4' : "window.parent.addTab", //tab标签
	}
	// 应用操作按钮处理
	JLEUtil.actionHandler = function(e, dgName, appId, actionId) {
		try {
			let app = JSON.parse(localStorage.getItem(appId));
			let action = JSON.parse(localStorage.getItem(appId+actionId));
			console.log(dgName, app, action);
			let parseExp = function(exp) {
				return eval("`"+exp+"`")
			}
			if (action.actionWay == 'page') {
				// 打开页面
				let command = actionDialogMap[action.actionDialog] || 'JLEUtil.createTopModalWin';
				eval(`${command}("${parseExp(action.actionTitle)}", "${parseExp(action.actionUrl)}")`);
			} else if (action.actionWay == 'api') {
				// 调用接口
			} else if (action.actionWay == 'shell') {
				// 调用脚本
			}
		} catch(e) {
			console.error('应用操作按钮处理异常', e)
		}
	}
})(jQuery);

//扩展jquery easyui tree的节点检索方法。使用方法： $("#treeId").tree("search", searchText);
(function($) {
	function init() {
		if (!$.fn.tree) {
			setTimeout(init, 500);
			return;
		}
		$.extend($.fn.tree.methods, {
			// searchText 检索的文本
			search: function(jqTree, text, id) {
				//easyui tree的tree对象。可以通过tree.methodName(jqTree)方式调用easyui tree的方法
				var tree = this;
				//获取所有的树节点
				var root = tree.getRoot(jqTree);
				var nodes = jqTree.tree("getData", root.target);
				var node=walkTree(jqTree,nodes.children,text, id);
				if (node) {
					jqTree.tree('expandTo', node.target)
					jqTree.tree('scrollTo', node.target);
					node.target.click();
				}
				return node;
			},
		});

		/**
		 * 添加校验方法 校验应用代码与应用名称
		 * 应用代码、应用名称、目录代码、目录名称、服务模型代码、服务模型名称、组件代码、组件名称、领域模型代码、领域模型名称
		 *
		 */
		$.extend($.fn.validatebox.defaults.rules, {
			code: {
				validator: function(value, param){
					return !!(value || '').match(/^[a-zA-Z]+[a-zA-Z0-9\-\_]*$/)
				},
				message: '代码校验失败'
			},
			name: {
				validator: function(value, param){
					return !!(value || '').match(/^[a-zA-Z\u4e00-\u9fa5]+[a-zA-Z0-9\-\_\u4e00-\u9fa5\(\)\%]*$/)
				},
				message: '名称校验失败'
			}
		});
	}

	function walkTree(jqTree,nodes,text, id){
		var result;
		for(var i in nodes){
			var node=jqTree.tree("getNode", nodes[i].target);
			if (id) {
				if(!node.children && node.text===text && node.id == id){
					result = node;
				}else if(node.children){
					var child=walkTree(jqTree,node.children,text, id);
					if(child && child.text===text && node.id == id )
						result = child;
				}
			} else {
				if(node.text===text){
					result = node;
				}else if(node.children){
					var child=walkTree(jqTree,node.children,text);
					if(child && child.text===text )
						result = child;
				}
			}
		}
		return result;
	}

	init();
})(jQuery);

$.ajaxSetup ({
	cache: false //关闭AJAX相应的缓存
});

/**
 其展示内容的格式为：
 金融云交付环境-广发POC-贷款管理服务(nrcs-lms)
 规则为：
 如果没有所属业务系统及所属应用，则展示为：
 金融云交付环境
 如果没有所属应用，则展示为：
 金融云交付环境-广发POC
 * @param value
 * @param row
 */
function formatter_server(value, row) {
	let values = [];
	if (row.envId) {
		values.push(formatter_ENV_ID(row.envId))
	}
	if (row.subsName) {
		values.push(row.subsName)
	}
	if (row.appName) {
		let appName = row.appName
		if (row.appCode) {
			appName = appName + `(${row.appCode})`;
		}
		values.push(appName)
	}

	return values.join("-")
}
/**
 其展示内容的格式为：
 贷款管理服务(nrcs-lms)
 * @param value
 * @param row
 */
function formatter_app(value, row) {
	let values = [];
	let tooltip = [];
	if (row.envId) {
		tooltip.push(formatter_ENV_ID(row.envId))
	}
	if (row.subsName) {
		tooltip.push(row.subsName)
	}
	if (row.appName) {
		values.push(row.appName)
	}
	if (row.appCode) {
		values.push(`(${row.appCode})`)
	}
	return `<span class="dg-tooltip" tooltipContent=${tooltip.join("-")}>${values.join("")}</span>`;
}

function formatter_ecsIpName(value, row) {
	// 鼠标停留显示服务器名称
	return `<span class="dg-tooltip" tooltipContent=${row.ecsName}>${row.ecsIp || ''}</span>`;
}

function parseDgTooltip() {
	setTimeout(function(){
		$('.dg-tooltip').each(function(index, el){
			$(el).tooltip({
				position: 'right',
				content: `<span >${$(el).attr('tooltipContent')}</span>`,
			});
		})
	}, 50)
}


let OWN_SOLUTION_TYPE = [
	{cnname: '全部', enname: 'BS,MS,PS'},
	{cnname: '业务系统', enname: 'BS'},
	{cnname: '中台系统', enname: 'MS'},
	{cnname: '底座系统', enname: 'PS'}
	// {cnname: 'SDK', enname: 'SS'}
]