(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global, global.loadjs));
})(this, (function (exports, _) {

    exports.TaskQueue = function() {
        const DEBUG = false
        this.tasks = []
        this.head = null
        this.count = 0 // 任务执行计数
        this.success = 0 // 成功数
        this.fail = 0 // 失败数
        this.total = 0 // 任务总数
        // 任务添加
        this.push = function (execute = function( callback, prevStatus, prevArgs, instance) {}) {

            this.tasks.push((params)=>{
                const {prevStatus, preArgs} = params || {}
                DEBUG && console.log("queue exec ", prevStatus, preArgs)
                return new Promise(
                    (resolve, reject)=>{
                        this.count++
                        const callback = (result, args)=>{
                            DEBUG && console.log("queue callback ", result, args)
                            if (result) {
                                this.success++
                                resolve({
                                    prevStatus: result,
                                    preArgs: args
                                })
                            } else {
                                this.fail++
                                reject({prevStatus: result, preArgs: args})
                            }
                        }
                        execute(callback, prevStatus, preArgs, this)
                    }
                )
            })
        }
        /**
         * 开始执行任务
         * @param {*} failContinue  失败后是否继续执行后续任务 默认为否
         */
        this.start = function(failContinue = false, catchFunc) {
            failContinue = !!failContinue
            if (!catchFunc) {
                catchFunc = (args)=>{
                    console.error(args)
                }
            }
            // 将 错误回调 包一层 promise 方便传递参数
            const catchPromise = (args)=> new Promise((resolve, reject)=>{
                catchFunc(args)
                reject(args)
            })
            DEBUG && console.log("queue start ", failContinue)
            if (this.tasks && this.tasks.length > 0) {
                this.total = this.tasks.length
                this.tasks.forEach((task, index)=>{
                    if (index == 0) {
                        this.head = task()
                    } else {
                        if (failContinue) {
                            this.head = this.head.then(task, task).catch(catchPromise)
                        } else {
                            this.head = this.head.then(task, catchPromise)
                        }
                    }
                })
            }
            return this.head
        }
    }
}));
