(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FilterItem = {
        props: {
            config: Object,
            disabled: Boolean,
            labelWidth: {
                type: String,
                default: '100px'
            },
        },
        inject: [ 'filterCond' ],
        data(){
            return {
                visible: false,

                initFlag: false,
            }
        },
        watch: {
            "filterCond": {
                handler: function(val){
                    if (val && vue.unref(val)) {
                        this.initFlag = true
                    }
                },
                deep: true
            },
            "values": {
                handler: function(val){
                    if (this.options && this.options.length > 0 && this.config.opType) {
                        // 翻译字典项到 valueNames
                        let items = this.options.filter(el=>val.indexOf(el.enname)>=0)
                        if (items && items.length > 0) {
                            items = items.map(el=>el.cnname)
                        }
                        this.valueNames = items
                    }
                },
                deep: true
            }
        },
        methods: {
            findCurrentCond() {
                const condList = vue.unref(this.filterCond);
                let item = condList.find(el=>el.name === this.config.name)
                if (item) {
                    return item
                } else {
                    item = {
                        ...this.config,
                        op: ( (this.config.opOption[0] || {} ).enname ) || 'eq',
                        values: [],
                        valueNames: [],
                        // 月份 周
                        thisDate: ['month', 'week', 'day'].indexOf(this.config.type)>=0 ? {
                            "weekId": "",
                            "year": "",
                            "weekNumber": "",
                            "startDate": "",
                            "endDate": "",
                            "month": '',
                        } : undefined,
                    }
                    condList.push(item)
                }
                return item;
            },

            monthHandler(val) {
                this.startValue = moment(val, 'YYYY-MM').startOf('month').format('YYYY-MM-DD')
                this.endValue = moment(val, 'YYYY-MM').endOf('month').format('YYYY-MM-DD')
            },
            dayHandler(val) {
                this.startValue = val
                this.endValue = val
            },

            resetThisDate() {
                this.startValue = '';
                this.endValue = '';
            },

            selectWeek() {
                // 选择周日历
                const self = this;
                ElementDialog.createDialog('选择周日历信息', '/allinrdm/page/project/console/popRdmWeeklyCalendarList.html')
                    .then(week=>{
                        self.thisDate.year = week.year;
                        self.thisDate.weekNumber = week.weekNumber;
                        self.thisDate.startDate = week.startDate;
                        self.thisDate.endDate = week.endDate;
                        self.startValue = this.thisDate.startDate;
                        self.endValue = this.thisDate.endDate;
                    })
            },
            selectDialog() {
                const self = this;
                ElementDialog.createDialog(self.config.title, self.config.url)
                    .then((selection)=>self.config.callback(self.findCurrentCond(), selection));
            }
        },
        computed:{
            showOp() {
                const { type, op } = this.config
                if (['month', 'week', 'day'].indexOf(type) >= 0 ) {
                    return false
                } else if (op == 'eg'){
                    return false
                } else {
                    return true
                }
            },
            thisDate: {
                get() {
                    const item = this.findCurrentCond();
                    return item.thisDate
                },
                set(val) {
                    const item = this.findCurrentCond();
                    Object.assign(item.thisDate, val)
                }
            },
            weekFormatterText() {
                return this.thisDate.weekNumber ? `${this.thisDate.year}年第${this.thisDate.weekNumber}周` : ''
            },
            op: {
                get() {
                    const item = this.findCurrentCond();
                    return item.op
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.op = val
                }
            },
            valueNames: {
                get() {
                    const item = this.findCurrentCond();
                    return item.valueNames
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.valueNames = val
                }
            },
            values: {
                get() {
                    const item = this.findCurrentCond();
                    return item.values
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.values = val
                }
            },
            startValue: {
                get() {
                    const item = this.findCurrentCond();
                    return item.values[0]
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.values.splice(0, 1, val)
                }
            },
            endValue: {
                get() {
                    const item = this.findCurrentCond();
                    return item.values[1]
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.values.splice(1, 1, val)
                }
            },
            options(){
                if (_.isArray(this.config.opType)) {
                    return this.config.opType;
                } else {
                    return window[this.config.opType] || []
                }
            }
        },
        mounted() {
            if(this.filterCond && vue.unref(this.filterCond)) {
                this.initFlag = true;
            }
        },
        unmounted() {
        },
        template: `
<el-col :span="12" style="margin-bottom: 8px;">
    <el-form-item :label="config.name" class="filter-item" v-if="initFlag" :label-width="labelWidth" class="filter-cond-item">
        <div v-if="showOp" style="flex: 0 0 100px;">
            <combobox v-model="op" :op-type="config.opOption" :clearable="false" :disabled="disabled" class="filter-cond-op-combobox"></combobox>
        </div>
        <div style="flex: 1; display:flex; height: 24px;" class="filter-cond-value-content">
            <template v-if="config.type == 'select'">
                <combobox v-if="config.multiple" v-model="values"  :placeholder="config.name" multiple :op-type="options" :disabled="disabled" ></combobox>
                <combobox v-model="startValue"  :placeholder="config.name" :op-type="options" :disabled="disabled" ></combobox>
            </template>
            <template v-else-if="config.type == 'radio'">
                <el-radio-group v-model="startValue" :disabled="disabled">
                    <el-radio v-for="(el, index) in options" :label="el.enname" >{{ el.cnname }}</el-radio>
                </el-radio-group>
            </template>
            <template v-else-if="config.type == 'checkbox'">
                <el-checkbox-group v-model="values" :disabled="disabled">
                    <el-checkbox v-for="(el, index) in options" :label="el.enname" >{{ el.cnname }}</el-checkbox>
                </el-checkbox-group>
            </template>
            <template v-else-if="config.type == 'userCombobox'">
                <user-combobox v-model="startValue"   :placeholder="config.name" :disabled="disabled" @select-label="name=>valueNames = [name]"></user-combobox>
            </template>
            <template v-else-if="config.type == 'TeamMemberCombobox'">
                <component :is="config.type" v-model="startValue" v-bind="config.params" :placeholder="config.name" :disabled="disabled" @select-label="name=>valueNames = [name]" ></component>
            </template>
            <template v-else-if="config.type == 'month'">
                <own-date-picker
                    v-model="thisDate.month" clearable :disabled="disabled"
                    type="month"
                    format="YYYY-MM"
                    value-format="YYYY-MM"
                    placeholder="选择月份" @change="monthHandler"
                ></own-date-picker>
            </template>
            <template v-else-if="config.type == 'week'">
                <el-input :model-value="weekFormatterText" clearable  @clear="resetThisDate()" :disabled="true" placeholder="待选择">
                    <template #append>
                        <el-button @click="selectWeek" :disabled="disabled" >选择</el-button>
                    </template>
                </el-input>
            </template>
            <template v-else-if="config.type == 'day'">
                <own-date-picker
                    v-model="thisDate.startDate" clearable :disabled="disabled"
                    type="date"
                    format="YYYY-MM-DD"
                    value-format="YYYY-MM-DD"
                    placeholder="选择日期" @change="dayHandler"
                ></own-date-picker>
            </template>
            <template v-else-if="config.type == 'dialog'">
                <el-input :model-value="valueNames.join(',')" clearable :disabled="true" placeholder="待选择">
                    <template #append>
                        <el-button @click="selectDialog" :disabled="disabled" >选择</el-button>
                    </template>
                </el-input>
            </template>
            <template v-else-if="config.type == 'datetime'">
                <el-date-picker  :disabled="disabled" placeholder="待选择"  style="flex: 1" v-if="op === 'btw' "
                        v-model="values" 
                        type="datetimerange"
                        :format="config.format || 'YYYY-MM-DD hh:mm:ss'"
                        :value-format="config.format || 'YYYY-MM-DD hh:mm:ss'"
                        range-separator="~"
                        start-placeholder="起始时间"
                        end-placeholder="终止时间"
                ></el-date-picker>
                <own-date-picker  :disabled="disabled" placeholder="待选择"  style="flex: 1" v-else
                        v-model="startValue" 
                        type="datetime"
                        :format="config.format || 'YYYY-MM-DD hh:mm:ss'"
                        :value-format="config.format || 'YYYY-MM-DD hh:mm:ss'"
                ></own-date-picker>
            </template>
            <template v-else-if="config.type == 'date'">
                <own-date-picker  :disabled="disabled" placeholder="待选择"  style="flex: 1" v-if="op === 'btw' "
                        v-model="values" 
                        type="daterange"
                        :format="config.format || 'YYYY-MM-DD'"
                        :value-format="config.format || 'YYYY-MM-DD'"
                        range-separator="~"
                        start-placeholder="起始日期"
                        end-placeholder="终止日期"
                ></own-date-picker>
                <own-date-picker  :disabled="disabled" placeholder="待选择"  style="flex: 1" v-else
                        v-model="startValue" 
                        type="date"
                        :format="config.format || 'YYYY-MM-DD'"
                        :value-format="config.format || 'YYYY-MM-DD'"
                ></own-date-picker>
                
            </template>
            <template v-else-if="config.type == 'number'">
                <el-input-number v-model="startValue" :disabled="disabled"  placeholder="待输入" :controls="false" style="flex: 1"></el-input-number>
                <template v-if="op === 'btw' ">
                    <div style="flex: 0 0 30px; text-align: center;">~</div>
                    <el-input-number v-model="endValue" :disabled="disabled"  placeholder="待输入" :controls="false" style="flex: 1"></el-input-number>
                </template>
            </template>
            <template v-else>
                <el-input v-model="startValue" :disabled="disabled"  placeholder="待输入"></el-input>
            </template>
        </div>
    </el-form-item>
</el-col>
        `
    }
}));
