(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FilterItemText = {
        props: {
            config: Object,
            disabled: Boolean,
        },
        inject: [ 'filterCond', 'filterConfig' ],
        data(){
            return {
                visible: false,

            }
        },
        methods: {
            formatter_dict(value,dictObj){
                for(var i=0;i<dictObj.length;i++){
                    if(value == dictObj[i].enname)
                        return dictObj[i].cnname;
                }
            },
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    try {
                        if (window[dicName]) {
                            return formatter_dict(value, window[dicName])
                        } else {
                            console.error(dicName, e)
                        }
                    } catch(e1) {
                        console.error(dicName, e)
                    }
                }
            },
            findCurrentConfig() {
                const configList = vue.unref(this.filterConfig);
                let item = configList.find(el=>el.name === this.config.name) || {}
                return item;
            },

            findCurrentCond() {
                const condList = vue.unref(this.filterCond);
                let item = condList.find(el=>el.name === this.config.name)
                if (item) {
                    return item
                } else {
                    item = {
                        ...this.config,
                        op: 'eq',
                        values: [],
                        valueNames: [],
                        // 月份 周
                        thisDate: ['month', 'week', 'day'].indexOf(this.config.type)>=0 ? {
                            "weekId": "",
                            "year": "",
                            "weekNumber": "",
                            "startDate": "",
                            "endDate": "",
                            "month": '',
                        } : undefined,
                    }
                }
                return item;
            },
            removeCond() {
                const condList = vue.unref(this.filterCond);
                let item = condList.find(el=>el.name === this.config.name)
                if (item) {
                    item.values.splice(0, item.values.length)
                    item.valueNames.splice(0, item.values.length)
                    if(item.thisDate) {
                        Object.assign(item.thisDate, {
                            "weekId": "",
                            "year": "",
                            "weekNumber": "",
                            "startDate": "",
                            "endDate": "",
                            "month": '',
                        })
                    }
                    this.$emit('remove', item)
                }
            }

        },
        computed:{
            thisDate: {
                get() {
                    const item = this.findCurrentCond();
                    return item.thisDate
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.thisDate = val
                }
            },
            weekFormatterText() {
                return `${this.thisDate.year}年第${this.thisDate.weekNumber}周`
            },
            valueFormatterText() {
                if (this.valueNames && this.valueNames.length > 0) {
                    return this.valueNames.join(', ')
                } else {
                    return this.values.join(', ')
                }
            },
            op: {
                get() {
                    const item = this.findCurrentCond();
                    return item.op
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.op = val
                }
            },
            valueNames() {
                const item = this.findCurrentCond();
                let names = item.valueNames
                if (names && names.length > 0) {
                    return names;
                } else if (this.opType && this.options.length > 0) {
                    let items = this.options.filter(el=>this.values.indexOf(el.enname)>=0)
                    if (items && items.length > 0) {
                        items = items.map(el=>el.cnname)
                    }
                    return items
                } else {
                    return names || []
                }
            },
            values() {
                const item = this.findCurrentCond();
                return item.values
            },
            startValue: {
                get() {
                    const item = this.findCurrentCond();
                    return item.values[0]
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.values.splice(0, 1, val)
                }
            },
            endValue: {
                get() {
                    const item = this.findCurrentCond();
                    return item.values[1]
                },
                set(val) {
                    const item = this.findCurrentCond();
                    item.values.splice(1, 1, val)
                }
            },
            opType() {
                const condConfig = this.findCurrentConfig();
                return (this.config.opType || condConfig.opType);
            },
            options(){
                const opType = this.opType
                if (_.isArray(opType)) {
                    return opType;
                } else {
                    return window[opType] || []
                }
            }
        },
        mounted() {
        },
        unmounted() {
        },
        template: `
<div class="filter-cond-item-text">
    <template v-if="config.type == 'month'">
        <span>{{config.name}}</span><span>{{ formatterDic('FILTER_OP_TYPE', 'eq') }}</span><span>"{{ thisDate.month }}"</span>
    </template>
    <template v-else-if="config.type == 'week'">
        <span>{{config.name}}</span><span>{{ formatterDic('FILTER_OP_TYPE', 'eq') }}</span><span>"{{ weekFormatterText }}"</span>
    </template>
    <template v-else-if="config.type == 'day'">
        <span>{{config.name}}</span><span>{{ formatterDic('FILTER_OP_TYPE', 'eq') }}</span><span>"{{ startValue }}"</span>
    </template>
    <template v-else>
        <span>{{config.name}}</span><span>{{ formatterDic('FILTER_OP_TYPE', config.op) }}</span><span>"{{ valueFormatterText }}"</span>
    </template>
    <el-button text icon="Close" @click="removeCond" size="small" v-if="!disabled"></el-button>
</div>
        `
    }
}));
