(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.OwnBreadcrumb = {
        props: {
            'breadcrumb': Array,
            'separator': {
                type: String,
                default : 'ArrowRightBold'
            },

            options: Array

        },
        emits: ['item-click'],
        data(){
            return {
                searchText: '',
                changeIcon: true
            }
        },
        methods: {
            handlerClickOption(item) {
                this.$emit('item-click', item)
                if (this.$refs.popoverRef) {
                    this.$refs.popoverRef[0].hide();
                    this.changeIcon = !this.changeIcon
                }

            },
            handlerBreadcrumbClick(b, index) {
                if (index == this.breadcrumb.length - 1 && this.$refs.btnRef) {
                    this.$refs.btnRef[0].$el.click();
                }
                this.$emit('breadcrumb-click', b)
            }
        },
        computed:{
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<div class="own-breadcrumb">
    <div v-for="(b, index) in breadcrumb" :key="index" class="own-breadcrumb-item" @click="handlerBreadcrumbClick(b, index)">
        <div class="own-breadcrumb-label">{{ b.text }}</div>
        <div v-if="b.showPop">
            <el-popover
                    ref="popoverRef" :popper-options="popperOptions" :width="250"
                    trigger="click"
                    :show-arrow="false"
                    placement="bottom" >
                <template #reference>
                    <el-button text icon="CaretBottom" ref="btnRef" style="--el-button-text-color: #FFF; background-color: transparent; padding: 5px;padding-right: 0px; padding-left: 0px; position: relative; right: -5px;"></el-button>
                </template>
                <div>
                    <el-input v-model="searchText" class="own-breadcrumb-options-search" placeholder="搜索" suffix-icon="Search" size="default"></el-input>
                    <el-scrollbar height="300px" :view-style="{ display: 'flex', 'flex-direction': 'column'}">
                        <el-button text class="own-breadcrumb-options-item" v-for="(item, index) in options.filter(el=>!searchText ? true : (el.id || '').indexOf(searchText) >= 0 || (el.text || '').indexOf(searchText) >= 0 )" 
                            :key="item.index" size="large" class="own-breadcrumb-option" @click="handlerClickOption(item)"><el-icon><i class="iconfont icon-yingyong"></i></el-icon>{{ item.text }}</el-button>
                    </el-scrollbar>
                </div>
            </el-popover>
            
        </div>
        <div v-if="index < breadcrumb.length - 1 "> <el-button class="own-breadcrumb-separator" text :icon="separator" style="--el-button-text-color: #FFF;" @click.stop.prevent="()=>{}" ></el-button></div>
    </div>
    
    
</div>
        `
    }
}));
