(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.PageSearch = {
        props: {
            dgUrl: String,
            restMethod: {
                type: String,
                default: 'restfulPostForm'
            },
            queryParams: Object,
            enableFilter: Boolean,
            filterTitle: String,
            filterOpType: [String, Array],
            filterKey: String,
            filterCountMethod: Function,
            filterCountLocal: Object,
            filterNoNum: Boolean,

            modelValue: String,

            enableSearch: Boolean,
            allItems: Array
        },
        emits: ['update:modelValue', 'allSearch'],
        inject: ['DIC'],
        data(){
            return {
                all: '',
                allName: 'all',
                filterCountData: {},
            }
        },
        methods: {
            allSearch() {
                this.$emit("allSearch", {
                    allName: this.allName,
                    all: this.all,
                })
            },
            refreshFilterCountFunc(type) {
                const self = this;
                if (self.filterCountLocal) {
                    this.filterCountData = {
                        ...self.filterCountLocal
                    }
                    return;
                }
                if (self.filterCountMethod) {
                    self.filterCountMethod(type).then(function(data){
                        self.filterCountData[type] = data.total;
                    })
                } else {
                    let params = {
                        size: 1,
                        page: 1,
                        ...Vue.unref(self.queryParams)
                    }
                    if (!self.filterKey) {
                        return;
                    }
                    params[self.filterKey] = type == 'ALL_TYPE' ? '' : type;
                    $[self.restMethod](self.dgUrl, params, function(data){
                        self.filterCountData[type] = data.total;

                    }, function(){ }, true);
                }

            },
            refreshFilterCount() {
                const self = this;
                if (!this.enableFilter) return;
                let dic = undefined
                if (_.isArray(self.filterOpType)) {
                    dic = self.filterOpType;
                } else {
                    dic = (self.DIC || {})[self.filterOpType] || []
                }
                dic.forEach(function(el){
                    self.refreshFilterCountFunc(el.enname);
                })
            },
            refreshCurrentCount() {
                this.refreshFilterCountFunc(this.all);
            }
        },
        watch: {
            filterOpType(val) {
                this.refreshFilterCount();
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            filterTitleCmp() {
                if (this.filterTitle) {
                    return this.filterTitle + '：'
                } else {
                    return '';
                }
            },
            filterTitleWidth() {
                if (this.filterTitleCmp) {
                    return '133px';
                } else {
                    return '0px';
                }
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.refreshFilterCount();
        },
        unmounted() {

        },
        template: `
<div>
    <slot name="more"></slot>
    <el-row v-if="enableFilter">
        <el-col :span="24">
            <el-form-item :label="filterTitleCmp" class="filter-item align-right" :label-width="filterTitleWidth">
                <filter-radio-group
                        class="table-filter-radio"
                        v-model="value"
                        @change="allSearch"
                        :filter-count-data="filterCountData"
                        :filter-no-num="filterNoNum"
                        :op-type="filterOpType"
                ></filter-radio-group>
            </el-form-item>
        </el-col>
    </el-row>
    <el-form class="table-search" v-if="enableSearch || $slots.tool">
        <el-row>
            <el-col :span="4" :sm="12" :xs="12" v-if="enableSearch">
                <el-form-item >
                    <el-input
                            v-model="all"
                            placeholder="关键字"
                            class="input-with-select"
                            @keydown.enter="allSearch"
                    >
                        <template #prepend>
                            <el-select v-model="allName" placeholder="模糊搜索" :popper-options="popperOptions" style="width: 115px">
                                <el-option label="模糊搜索" value="all" ></el-option>
                                <el-option v-for="(item, index) in allItems" :label="item.label" :value="item.value" ></el-option>
                            </el-select>
                        </template>
                        <template #append>
                            <el-button icon="Search" @click="allSearch" />
                        </template>
                    </el-input>
                </el-form-item>
    
            </el-col>
            <el-col :span="4" :sm="12" :xs="12" v-if="$slots.tool">
                <slot name="tool"></slot>
            </el-col>
        </el-row>
    </el-form>
</div>
        `
    }
}));
