(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.FormItemRadioGroup = {
        props: {
            dgUrl: String,
            restMethod: {
                type: String,
                default: 'restfulPostJson'
            },
            queryParams: Object,
            queryParamsHandler: {
                type: Function,
                default: (params)=>params
            },
            filterOpType: [String, Array],
            filterKey: String,
            groupKey: String,
            filterCountMethod: Function,
            filterCountLocal: Object,
            filterNoNum: Boolean,
            filterLoopCount: Boolean, // 循环请求
            modelValue: String,
        },
        emits: ['update:modelValue', 'change'],
        inject: ['DIC'],
        data(){
            return {
                filterCountData: {},
            }
        },
        methods: {
            allSearch() {
                this.$emit("change", this.value)
            },
            refreshFilterCountFunc(type) {
                const self = this;
                if (self.filterCountLocal) {
                    this.filterCountData = {
                        ...self.filterCountLocal
                    }
                    return;
                }
                if (self.filterCountMethod) {
                    self.filterCountMethod(type).then(function(data){
                        self.filterCountData[type] = data.total;
                    })
                } else {
                    let params = {
                        size: 1,
                        page: 1,
                        ...Vue.unref(self.queryParams)
                    }
                    params = self.queryParamsHandler(params)
                    if (!self.filterKey) {
                        return;
                    }
                    params[self.filterKey] = type == 'ALL_TYPE' ? '' : type;
                    $[self.restMethod](self.dgUrl, params, function(data){
                        self.filterCountData[type] = data.total;

                    }, function(){ }, true);
                }

            },
            refreshFilterCount() {
                const self = this;
                let dic = undefined
                if (_.isArray(self.filterOpType)) {
                    dic = self.filterOpType;
                } else {
                    dic = (self.DIC || {})[self.filterOpType] || []
                }
                if (!dic || dic.length == 0) {
                    return;
                }
                if (this.filterLoopCount) { // 根据
                    dic.forEach(function(el){
                        self.refreshFilterCountFunc(el.enname);
                    })
                } else if (this.filterKey && (!this.filterCountMethod)) {

                    // 后台一次请求分组查询获取统计数据
                    let params = {
                        groupBy: this.groupKey || this.filterKey,
                        size: 100, // 不分页
                        page: 1,
                        ...Vue.unref(self.queryParams),
                    }
                    params = self.queryParamsHandler(params)
                    if (!_.isArray(params[this.filterKey])) {
                        delete params[this.filterKey]
                    }
                    // 不排序
                    delete params.ascOrder;
                    delete params.descOrder;
                    $[self.restMethod](self.dgUrl, params, function(data){
                        if (data.rows) {
                            // 重置统计数
                            dic.forEach(el=>{
                                self.filterCountData[el.enname] = 0
                            })
                            data.rows.forEach(el=>{
                                self.filterCountData[el[params.groupBy]] = el.groupNum
                            })
                            if(dic[0].enname == '' || dic[0].enname == 'ALL' || dic[0].enname == 'ALL_TYPE' || dic[0].cnname.indexOf('全部') >= 0) {
                                // 统计分项到全部
                                self.filterCountData[dic[0].enname ] = data.rows.reduce((a, b)=> a + b.groupNum, 0)
                            }
                        }
                    }, function(){ }, true);
                } else {
                    dic.forEach(function(el){
                        self.refreshFilterCountFunc(el.enname);
                    })
                }
            },
        },
        watch: {
            filterOpType(val) {
                this.refreshFilterCount();
            },
            queryParams: {
                handler(val) {
                    this.refreshFilterCount();
                },
                deep: true,
                flush: 'post'
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            }
        },
        mounted() {
            this.refreshFilterCount();
        },
        unmounted() {

        },
        template: `
<filter-radio-group
        class="table-filter-radio"
        v-model="value"
        @change="allSearch"
        :filter-count-data="filterCountData"
        :filter-no-num="filterNoNum"
        :op-type="filterOpType"
>
    <template #cancel>
        <slot name="cancel"></slot>
    </template>
</filter-radio-group>
        `
    }
}));
