(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.TreeMenu = {
        props: {
            defaultActive: String,
            activeFirst: Boolean,
            collapse: Boolean,
            showIcon: {
                type: Boolean,
                default: false
            },
            mode: String,
            data: Array,
            defaultOpeneds: {
                type: Array,
                default: ()=>['0', '0-0']
            },
            showLogo: Boolean,
            hideSearch: Boolean,
            topTitle: {
                type: String,
                default: ()=>undefined
            },
            uniqueOpened: {
                type: Boolean,
                default: false
            },
        },
        inject: ['searchParams'],
        emits: ['collapse', 'open', 'close', 'select'],
        data(){
            return {
                search: "",
                localCollapse: this.collapse,
            }
        },
        watch:{
            "localCollapse": function(val) {
                this.$emit('collapse', this.localCollapse)
            }
        },
        methods: {
            findTargetMenuItem(data, key, keyPath, parents) {
                if (key && key.split('-').length > 0) {
                    const keys = key.split('-');
                    let item = data, i = 0, len = keys.length;
                    while(i < len && item) {
                        item = item[keys[i]];
                        i++;
                        if (i < len) {
                            parents.push(item);
                            item = item.children
                        }
                    }
                    return item;
                } else {
                    return undefined;
                }
            },
            handleSelect(key, keyPath) {
                const parents = []
                const item = this.findTargetMenuItem(this.data, key, keyPath, parents)
                this.$emit('select', item, key, keyPath, parents)
            },
            handleOpen(key, keyPath) {
                const parents = []
                const item = this.findTargetMenuItem(this.data, key, keyPath, parents)
                this.$emit('open', item, key, keyPath, parents)
            },
            handleClose(key, keyPath) {
                const parents = []
                const item = this.findTargetMenuItem(this.data, key, keyPath, parents)
                this.$emit('close', item, key, keyPath, parents)
            },
            makeCollect() {
                this.localCollapse = true
            },
            handleContextMenu(item, key, event) {
                event.stopPropagation()
                this.$emit('contextMenu', item, key, event)
            },
            wrapperIndex() {
                let arr = [ ...arguments ].filter(el=>{ return el !== null || el !== undefined })
                return arr.join('-')
            },
            searchOnText(text) {
                this.search = text;
                this.searchMenu();
            },
            searchMenu() {
                const { search, data } = this;
                const self = this;
                if (search && search.length > 1) {
                    for (let i= 0; i < data.length; i++) {
                        this.recursionSearch(data[i], search);
                    }
                }
            },
            recursionSearch(data, search) {
                if (data.children && data.children.length > 0) {
                    let hide = true;
                    for (let i= 0; i < data.children.length; i++) {
                        let re = this.recursionSearch(data.children[i], search);
                        if (!re) {
                            hide = re;
                        }
                    }
                    data.serachHide = hide;
                } else {
                    data.serachHide = ! ( data.text.toLowerCase().indexOf(search.toLowerCase()) >= 0 );
                }
                return data.serachHide;
            },
            open(index) {
                if (this.$refs.menuRef) {
                    this.$refs.menuRef.open(index)
                }
            },
            handleNodeIconShow(node) {
                const self = this;
                const { searchMode, defaultIcon, showIcon, mode } = self;
                const hasIcon = !!( node.iconCls || node.icon )
                return showIcon && hasIcon
            }

        },
        computed:{
            searchMode() {
                const { search } = this;
                return search && search.length > 1
            },
            headerIcon() {
                return this.localCollapse ? 'Expand' : 'Fold'
            },
            defaultIcon() {
                return this.mode === 'horizontal' ? '' : 'icon-yingyong'
            },
            contextPath() {
                return window.contextPath;
            },
            logoUrl() {
                return this.contextPath + 'static/img/favicon-gitlab.png'
            },
            logoTitle() {
                return `${this.searchParams.cbaName || ''}`
            }
        },
        mounted() {
            const self = this;
            const {activeFirst,  data } = self;
            if (activeFirst) {
                if (data && data.length > 0) {
                    if (!data[0].children || data[0].children.length == 0) {
                        self.$emit('select', data[0])
                    } else if (data[0].children && data[0].children.length > 0) {
                        let child = data[0].children[0] ;
                        if (!child.children || child.children.length == 0) {
                            self.$emit('select', child)
                        } else {
                            child = child.children[0] ;
                            if (!child.children || child.children.length == 0) {
                                self.$emit('select', child)
                            }
                        }
                    }
                }
            }
        },
        unmounted() {

        },
        render() {
            const self = this;
            const { h } = Vue;
            const { searchMode, defaultIcon, showIcon, mode } = self;
            function createSearch() {
                let doms = []
                if (self.hideSearch ) {
                    return doms
                }
                if (!self.localCollapse) {
                    if (self.showLogo) {
                        doms.push(
                            h('div', { class:  "tree-menu-show-logo" },
                                [
                                    h('div',
                                        {
                                            class:  "tree-menu-show-logo-ctx"
                                        },
                                        [
                                            h(CardComponents.HeaderLogo, { class: 'tree-menu-show-logo-ctx-favicon'}),
                                            h('div', { class: 'tree-menu-show-logo-ctx-title'}, self.logoTitle),
                                        ]
                                    ),

                                ]
                            )
                        )
                    } else if (self.topTitle) {
                        doms.push(
                            h('div', { style:  "flex: 1; text-align: left; margin: 0 5px; --el-component-size: 32px", class: 'tree-menu-top-title' },
                                self.topTitle)
                        )
                    } else {
                        doms.push(
                            h('div', { style:  "flex: 1; text-align: left; margin: 0 5px; --el-component-size: 32px" },
                                [
                                    h(ElementPlus.ElInput,
                                        {
                                            modelValue : self.search,
                                            onInput: (val)=>{ self.search = val} ,
                                            onChange: self.searchMenu,
                                            clearable: true,
                                            placeholder: "导航搜索",
                                            style : { "width": "100%"}
                                        }
                                    ),

                                ]
                            )
                        )
                    }
                }
                doms.push(h('div', { style: { flex: `0 0 30px`, margin: self.localCollapse ? '0 5px' : undefined ,'padding-left' : self.localCollapse ? '2px' : '0', '--el-fill-color-light': self.localCollapse ? 'var(--index-nav-bg-color)' : undefined } }, [
                    h(ElementPlus.ElButton, {
                        text: true,
                        class: { 'tree-menu-collapse-color' : self.showLogo },
                        icon: self.headerIcon,
                        onClick: ()=>{ self.localCollapse = !self.localCollapse }
                    })
                ]))
                return doms;
            }
            function createMenuItemTitle(node) {
                if (node.summaryCount) {
                    // 展示统计项
                    return [
                        h('span', node.text + `(${node.summaryCount || 0})`),
                        // h('span', { style: "font-weight: bold;" }, node.summaryCount),
                    ]
                } else if (node.rightButton) {
                    // 展示按钮
                    return [
                        h('span', node.text),
                        node.rightButton,
                    ]
                } else {
                    return h('span', node.text)
                }

            }
            function createMenuItem(node, index, parent, pKeyPath) {
                if (node.children && node.children.length > 0 && !node.hide && ( searchMode ? !node.serachHide : true )) {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    return h(ElementPlus.ElSubMenu, {
                        index: menuKey,
                        key: index,
                    }, {
                        title: ()=>[
                            h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                node.iconCls && node.iconCls.startsWith('#')
                                    ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                    : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})  ),
                            h('span', { style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;", onClick: (event)=>{ node.stopClickOnLabel && event.stopPropagation();  self.handleSelect(menuKey) ; }, onContextmenu: (event)=>self.handleContextMenu(node, menuKey, event) },  createMenuItemTitle(node))
                        ],
                        default: ()=> node.children.map(function(el, elIdx){
                            return createMenuItem(el, elIdx, node, [...pKeyPath, index])
                        })
                    })
                } else if (!node.hide && ( searchMode ? !node.serachHide : true )) {
                    const menuKey = self.wrapperIndex.apply(self, [...pKeyPath, index])
                    node.menuKey = menuKey
                    return h(ElementPlus.ElMenuItem, {
                        index: menuKey,
                        key: index,
                    }, {
                        default: ()=>[
                            h(ElementPlus.ElIcon, { style: { "display" : self.handleNodeIconShow(node) ? undefined : 'none' }, class: [ 'tree-menu-icon']},
                                node.iconCls && node.iconCls.startsWith('#')
                                    ? h('svg', { class: [ "icon", "svg-icon" ], style: { 'padding-right': '5px', 'font-size': '14px' }}, h('use', { 'xlink:href': node.iconCls }))
                                    : h('i', { class: [ "iconfont",  node.iconCls || node.icon || defaultIcon ]})
                            )
                        ],
                        title: ()=>[
                            h('span', { style: "width: 100%; flex: 1; display: flex; align-items: center; justify-content: space-between;", onContextmenu: (event)=>self.handleContextMenu(node, menuKey, event) },  createMenuItemTitle(node))
                        ]
                    })
                }
            }
            if(self.mode === 'horizontal') {
                return h('div', { style: { "padding-top": "0px"}}, [
                    h(ElementPlus.ElMenu, {
                        defaultActive: self.defaultActive,
                        class: "tree-menu",
                        collapse: self.localCollapse,
                        mode: self.mode,
                        defaultOpeneds: self.defaultOpeneds,
                        onSelect: self.handleSelect,
                        onOpen: self.handleOpen,
                        onClose: self.handleClose,
                        ref: 'menuRef'
                    }, self.data.map(function(el, index){
                        return createMenuItem(el, index, null, [])
                    }))
                ])
            } else {
                return h('div', { style: { "padding-top": self.showLogo? "o" : "5px"}}, [
                    h('div', { class: {"tree-menu-header" : true, "tree-menu-header-bg" : self.showLogo, "tree-menu-header-border-b": !!self.topTitle} }, createSearch()),
                    h(ElementPlus.ElMenu, {
                        defaultActive: self.defaultActive,
                        class: "tree-menu",
                        collapse: self.localCollapse,
                        mode: self.mode,
                        defaultOpeneds: self.defaultOpeneds,
                        onSelect: self.handleSelect,
                        onOpen: self.handleOpen,
                        onClose: self.handleClose,
                        uniqueOpened: self.uniqueOpened,
                        ref: 'menuRef'
                    }, self.data.map(function(el, index){
                        return createMenuItem(el, index, null, [])
                    }))
                ])
            }
        },
    }
}));
