(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    /**
     *  头部logo
     */
    exports.UnionHeaderLogo = {
        props: {
            module: Object,
            drawerShow: Boolean,
            logoShow: {
                type: Boolean,
                default: true
            },
            suffixDesc: {
                type: String
            }
        },
        data() {
            return {
                e4aIntegerType: 'L',
                logoUrl: '',
            }
        },
        methods: {

        },
        computed: {
            moduleTitle() {
                if (!this.module) return '';
                // return this.module.moduleShort;
                return this.module.moduleName;
            },
            moduleIcon() {
                if (!this.module) return '';
                return this.module.moduleIcon;
            }
        },
        mounted() {
            const self = this;
            $.restfulGet(window.contextPath + 'client/e4a/integer/type', null, function (data) {
                self.e4aIntegerType = data.rows;
                self.$emit('integerType', self.e4aIntegerType)
            }, $.noop, true)
            $.restfulGet(window.contextPath + 'client/e4a/logo/url', null, function (data) {
                self.logoUrl = data.rows || '';
            }, $.noop, true)
        },
        template: `
<div style="display:flex;" :style="{ 'flex' : module ? '1' : drawerShow ? '0 0 95px' : '0 0 95px'}">
    <div style="overflow: hidden; padding-left: 5px; flex: 0 0 160px;" v-if="logoUrl && logoShow">
        <img :src="logoUrl" style="width: 160px; height: 35px;"></img>
    </div>

    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center;" v-if="!!module"> 
        <i class="divider-i" v-if="logoUrl && logoShow"></i>
        <template v-if="moduleIcon.startsWith('#icon')">
            <svg class="icon svg-icon" style="color: #FFF; padding-right: 5px; font-size: 14px; " aria-hidden="true"><use :xlink:href="moduleIcon"></use></svg>   
        </template>
        <template v-else>
            <i class="iconfont" :class="[ moduleIcon ]" style="font-size: 18px;"></i>
        </template>
        {{ moduleTitle }}
        <template v-if="suffixDesc">
            <i class="divider-i" style="padding-left: 12px;"></i>
            {{ suffixDesc }}
        </template>
    </div>
    <div style="line-height: var(--index-nav-line-height); display: inline-flex; justify-content: left; align-items: center; flex: 0 0 5px;" v-else> 
       <i class="divider-i"></i>
    </div>
</div>
        `
    }
}));
