(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.UserCombobox = {
        props: {
            modelValue: String,
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            multiple: Boolean,
            url: {
                type: String,
                default: '/allincloud/api/s/users'
            }
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change', 'selectLabel'],
        data(){
            return {
                users:[],
            }
        },
        methods: {
            queryUsers() {
                const self = this ;
                $.restfulPostForm(this.url, { size: 100}, function(data) {
                    self.users = data.rows;
                }, function(e) {}, true)
            },
            handlerChange(val) {
                const item = this.users.find(function(el){ return val == el.actorno}) || {}
                this.$emit('change', val, item.actorname)
                this.$emit('selectLabel', item.actorname)
            },
            getUserName(val) {
                const item = this.users.find(function(el){ return val == el.actorno}) || {}
                return item.actorname
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            DIC(){
                return window[this.opType] || []
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.queryUsers();
        },
        unmounted() {

        },
        template: `
<el-select v-model="value" class="m-2" :placeholder="placeholder" :popper-options="popperOptions" clearable filterable :multiple="multiple" :disabled="disabled || readonly" @change="handlerChange" >
    <el-option
            v-for="item in users"
            :key="item.actorno"
            :label="item.actorname"
            :value="item.actorno"
    />
</el-select>
        `
    }
}));
