(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.ViewDropdown = {
        props: {
            modelValue: String,
            disabled: Boolean,
        },
        emits: ['update:modelValue', 'view'],
        data(){
            return {
                currentItem: undefined
            }
        },
        methods: {
            handlerCommand(param) {
                if (param.command == 'viewModel') {
                    this.currentItem = param.item
                    this.$emit('view', param.item)
                    this.value = param.item.value;
                }
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            viewItems() {
                return [
                    {label: '看板视图', value: 'dashboard', icon: 'icon-kanbanshitu'},
                    {label: '列表视图', value: 'list', icon: 'icon-viewList-fill'},
                ]
            },
            displayLabel() {
                if (this.currentItem) {
                    return this.currentItem.label || ""
                } else {
                    return "";
                }
            },
            displayIcon() {
                if (this.currentItem) {
                    return this.currentItem.icon || ""
                } else {
                    return "icon-chakanyanjingshishifenxi2";
                }
            },
            displayValue() {
                if (this.currentItem) {
                    return this.currentItem.value || ""
                } else {
                    return "";
                }
            }
        },
        mounted() {
            const self = this;
            let initItem = this.viewItems.find(function(el){ return el.value == self.value });
            if (!initItem) {
                initItem = this.viewItems[1]; // 默认列表视图
            }
            this.currentItem = initItem ;
            // this.$emit('view', this.currentItem)
        },
        unmounted() {

        },
        template: `
<el-dropdown trigger="click" @command="handlerCommand" :disabled="disabled">
    <el-button class="button" text size="small" ><el-icon><i class="iconfont" :class="[displayIcon]"></i></el-icon>{{displayLabel}}</el-button>
    <template #dropdown>
      <el-dropdown-menu>
        <el-dropdown-item v-for="(item, index) in viewItems" :key="index" :command="{ command: 'viewModel', item: item}">
            <el-icon><i class="iconfont" :class="[item.icon]"></i></el-icon>{{item.label}}
            <span style="float: right; color: var(--el-text-color-secondary); display: inline-block; margin-left: 10px;" v-if="displayValue == item.value"><el-icon><Select></Select></el-icon></span>
        </el-dropdown-item>
      </el-dropdown-menu>
    </template>
</el-dropdown>
        `
    }
}));
