(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    /**
     *  底部按钮
     */
    exports.BottomButtons = {
        props: {
            submitForm: Function,
            submitBtnText: String,
            closeForm: Function,
            loading: Boolean,
            newDialogFlag: Boolean
        },
        data(){
            return {
                height: 0,
                useTop: false,
            }
        },
        methods: {
            handlerClick(val) {
                this.$emit('click', val)
            },

        },
        computed:{
            styleObject() {
                return {
                    bottom: "inherit",
                    top: this.height,
                }
            }
        },
        mounted() {
            const self = this;
            setTimeout(function() {
                $(window.parent.document).find('iframe').each(function(i, el){
                    if (el.contentWindow.document == document) {
                        let createTop = $(el).attr('create-top')
                        let height = $(el).height();
                        let winHeight = $(document).height();
                        self.useTop = height < winHeight
                        self.height = createTop == 'top' ? height - 40 : height - 80;
                    }
                })
            }, 50)
        },
        unmounted() {

        },
        template: `
<div :class="{ 'esaas-info-buttons': !newDialogFlag, 'element-dialog-button': newDialogFlag  }" :style="styleObject">
    <div>
        <slot name="prepend"></slot>
        <el-button v-if="submitForm" type="primary" round icon="Select" @click="submitForm" v-loading="loading" size="small">{{ submitBtnText }}<span v-if="!submitBtnText">&nbsp;保&nbsp;存&nbsp;</span></el-button>
        <el-button v-if="closeForm" type="default" round icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
        <slot name="append"></slot>
    </div>
</div>
        `
    }
}));
