(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.Combobox = {
        props: {
            modelValue: String,
            opType: [String, Array],
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            clearable: {
                type: Boolean,
                default: true
            },
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change', 'visibleChange'],
        data(){
            return {
                formItem: undefined
            }
        },
        methods: {
            handlerChange(val) {
                this.$emit('change', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
            handlerVisibleChange(val) {
                this.$emit('visibleChange', val)
            }
        },
        computed:{
            value: {
                get() {
                    return (this.modelValue || '') + ''
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            options(){
                if (_.isArray(this.opType)) {
                    return this.opType;
                } else {
                    return window[this.opType] || []
                }
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.formItem = vue.inject(ElementPlus.formItemContextKey)
        },
        unmounted() {

        },
        template: `
<el-select v-model="value" class="m-2" :placeholder="placeholder" :popper-options="popperOptions" :clearable="clearable" :disabled="disabled || readonly" 
     @visible-change="handlerVisibleChange"
     @change="handlerChange">
    <el-option
            v-for="item in options"
            :key="item.enname"
            :label="item.cnname"
            :value="item.enname"
    />
</el-select>
        `
    }
}));
