(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    exports.RichEditor = {
        props: {
            modelValue: String,
            disabled: Boolean,
            width: String,
            height: String,
        },
        inject: ['DIC'],
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                editor: undefined,
            }
        },
        watch: {
            disabled(val) {
                if (this.editor) {
                    this.editor.readonly(val)
                }
            },
            modelValue(val, oldVal) {
                if (this.editor) {
                    const editorVal = this.editor.html();
                    if(val != editorVal) {
                        this.editor.html(val);
                    }
                }
            }
        },
        methods: {
            initEditor() {
                const self = this;
                const $el = self.$el;
                const KindEditor = window.KindEditor;
                KindEditor.ready(function(K) {
                    self.editor = K.create($el, Vue.unref(self.options));
                    setTimeout(function(){ self.editor.readonly(self.disabled) }, 50)
                });
            },
            change() {
                if (this.editor) {
                    const val = this.editor.html();
                    this.value = val;
                    this.$emit('change', val)
                }
            }
        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            docTools() {
                return [ 'formatblock', 'fontname', 'fontsize', 'lineheight', '|', 'forecolor', 'hilitecolor', '|', 'bold', 'italic','underline', 'strikethrough', '|',
                    'justifyleft', 'justifycenter', 'justifyright', 'justifyfull', '|',
                    'insertorderedlist', 'insertunorderedlist', '|',
                    'emoticons', 'image', 'hr', '|', 'link', '|',
                    'undo', 'redo', '|', 'selectall', 'cut', 'copy', 'paste', '|', 'plainpaste', 'wordpaste', '|', 'removeformat', 'clearhtml','quickformat', '|',
                    'indent', 'outdent', 'subscript', 'superscript', '|',
                    'table', 'code', 'pagebreak',
                    'source']
            },
            simpleTools() {
                return [ 'formatblock', 'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic','underline', '|',
                    'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist', 'insertunorderedlist', '|',
                    'emoticons', 'image', 'code', 'link', 'table', '|', 'removeformat','undo', 'redo', 'fullscreen', 'source', 'about']
            },
            options() {
                return {
                    basePath: window.contextPath + 'static/kindeditor/',
                    pluginsPath: window.contextPath + 'static/kindeditor/plugins/',
                    themesPath: window.contextPath + 'static/kindeditor/themes/',
                    langPath: window.contextPath + 'static/kindeditor/lang/',
                    width: this.width || '100%',
                    height: this.height || '200px',
                    filterMode: true,
                    bodyClass: 'article-content',
                    urlType: 'absolute',
                    langType: 'zh_CN',
                    cssData: 'html,body {background: none}.article-content{overflow:visible}.article-content, .article-content table td, .article-content table th {line-height: 1.3846153846; font-size: 13px;}.article-content .table-auto {width: auto!important; max-width: 100%;}',
                    placeholder: '',
                    placeholderStyle: {fontSize: '14px', color: '#888'},
                    // pasteImage: {postUrl: createLink('file', 'ajaxPasteImg', 'uid=' + kuid)},
                    syncType: 'form',
                    allowFileManager: false,
                    spellcheck: false,
                    afterChange: this.change,
                    items: this.simpleTools
                }
            }

        },
        mounted() {
            const self = this;
            loadjs(window.contextPath + 'static/kindeditor/kindeditor-all.js?v=1.1', function(){
                if (window.KindEditor) {
                    self.initEditor()
                } else {
                    setTimeout(self.initEditor, 250)
                }
            })

        },
        unmounted() {

        },
        template: `
<textarea v-model="value"> </textarea>
        `
    }
}));
