/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.web.controller;

import com.alibaba.fastjson.JSON;
import com.irdstudio.framework.beans.core.util.ReflectUtility;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.UserInfo;
import com.irdstudio.framework.beans.web.controller.IController;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractController
implements IController {
    @Autowired
    protected HttpServletRequest httpRequest;
    @Autowired
    protected HttpServletResponse httpResponse;
    protected static Logger logger = LoggerFactory.getLogger(AbstractController.class);

    private final void setUserInfoToVO(UserInfo userInfo, Object[] params) {
        for (Object object : params) {
            if (object instanceof BaseInfo) {
                BaseInfo baseInfo = (BaseInfo)object;
                baseInfo.setLoginUserId(userInfo.getUserId());
                baseInfo.setLoginUserOrgLocation(userInfo.getOrgInfo().getOrgLocation());
                baseInfo.setLoginUserOrgCode(userInfo.getOrgInfo().getOrgCode());
                baseInfo.setLoginUserLeageOrgCode(userInfo.getLegalOrg().getOrgCode());
                continue;
            }
            ReflectUtility.invokeSetter((Object)object, (String)"loginUserId", (Object)userInfo.getUserId(), (boolean)false);
            ReflectUtility.invokeSetter((Object)object, (String)"loginUserLeageOrgCode", (Object)userInfo.getOrgInfo().getOrgLocation(), (boolean)false);
            ReflectUtility.invokeSetter((Object)object, (String)"loginUserOrgCode", (Object)userInfo.getOrgInfo().getOrgCode(), (boolean)false);
            ReflectUtility.invokeSetter((Object)object, (String)"loginUserOrgLocation", (Object)userInfo.getLegalOrg().getOrgCode(), (boolean)false);
        }
    }

    private final Method getCallMethod(Object serviceClass, String methodName, String dataRuleType) throws Exception {
        try {
            Method[] methods = serviceClass.getClass().getMethods();
            String mtdName = this.getCallMethodByDataRuleType(methodName, dataRuleType);
            List lists = Arrays.stream(methods).filter(m -> m.getName().equals(mtdName)).collect(Collectors.toList());
            if (Objects.nonNull(lists) && lists.size() > 0) {
                return (Method)lists.get(0);
            }
        }
        catch (Exception e) {
            logger.error("\u5f53\u524d\u83b7\u53d6\u8c03\u7528\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            throw e;
        }
        return null;
    }

    private final String getCallMethodByDataRuleType(String methodName, String dataRuleType) {
        if (StringUtils.isEmpty((CharSequence)dataRuleType)) {
            dataRuleType = "10";
        }
        String suffix = "";
        if (StringUtils.isNotEmpty((CharSequence)dataRuleType)) {
            for (DataRuleType type : DataRuleType.values()) {
                if (!dataRuleType.equals(type.getValue())) continue;
                suffix = type.toString();
                break;
            }
        }
        return methodName + suffix;
    }

    public final <T> T setUserInfoToVO(Object baseInfo) {
        try {
            UserInfo userInfo = this.getUserInfo();
            Object[] obj = new Object[]{baseInfo};
            this.setUserInfoToVO(userInfo, obj);
            return (T)obj[0];
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public final UserInfo getUserInfo() {
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.httpRequest.getSession().getAttribute("userInfo");
        }
        catch (ClassCastException e) {
            Object obj = this.httpRequest.getSession().getAttribute("userInfo");
            String json = JSON.toJSONString((Object)obj);
            userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        }
        return userInfo;
    }

    static enum DataRuleType {
        Owner("10"),
        CurrOrg("20"),
        CurrDownOrg("30");

        private String value;

        private DataRuleType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

