/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.web.http;

import com.irdstudio.framework.beans.web.http.HttpClient;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefRestfulHttpClient<I, O>
implements HttpClient<I, O> {
    HttpHeaders headers = new HttpHeaders();

    @Override
    public O httpCall(String url, I inArgs, Class<O> clazz) throws Exception {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        List messageConverters = restTemplate.getMessageConverters();
        Iterator iterator = messageConverters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter converter = (HttpMessageConverter)iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        messageConverters.add(new StringHttpMessageConverter(Charset.forName("utf-8")));
        this.headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        this.headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity(inArgs, (MultiValueMap)this.headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, clazz, new Object[0]);
        HttpStatus status = responseEntity.getStatusCode();
        if (status.is2xxSuccessful()) {
            return (O)responseEntity.getBody();
        }
        return null;
    }

    @Override
    public void setHeader(String key, String value) {
    }

    @Override
    public void setCookie(Collection<Cookie> cookies) {
        if (Objects.nonNull(cookies)) {
            ArrayList cookieList = new ArrayList();
            cookies.forEach(cookie -> cookieList.add(cookie.getName() + "=" + cookie.getValue()));
            this.headers.put("Cookie", cookieList);
        }
    }

    @Override
    public O httpCall(String url, HttpMethod method, I inArgs, Class<O> clazz, Object ... params) throws Exception {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        List messageConverters = restTemplate.getMessageConverters();
        Iterator iterator = messageConverters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter converter = (HttpMessageConverter)iterator.next();
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            iterator.remove();
        }
        messageConverters.add(new StringHttpMessageConverter(Charset.forName("utf-8")));
        this.headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        this.headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity(inArgs, (MultiValueMap)this.headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, method, entity, clazz, params);
        HttpStatus status = responseEntity.getStatusCode();
        if (status.is2xxSuccessful()) {
            return (O)responseEntity.getBody();
        }
        return null;
    }
}

