/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.framework.beans.web.feign;

import com.irdstudio.framework.beans.web.controller.BaseController;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FeignClientAutoRequestMapping
extends RequestMappingHandlerMapping {
    private RequestMappingInfo.BuilderConfiguration cacheConfig;
    private static final String OTHER_BASE_CONTROLLER_CLAZZ = "com.irdstudio.sdk.beans.web.controller.BaseController";
    public static final String suffix = "_client";

    protected boolean isHandler(Class<?> beanType) {
        if (beanType.getSuperclass() == BaseController.class) {
            return true;
        }
        if (beanType.getSuperclass() != null && StringUtils.equals((CharSequence)beanType.getSuperclass().getName(), (CharSequence)OTHER_BASE_CONTROLLER_CLAZZ)) {
            return true;
        }
        return super.isHandler(beanType);
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if ((handlerType.getSuperclass() == BaseController.class || handlerType.getSuperclass() != null && StringUtils.equals((CharSequence)handlerType.getSuperclass().getName(), (CharSequence)OTHER_BASE_CONTROLLER_CLAZZ)) && requestMapping == null && StringUtils.endsWithAny((CharSequence)method.getName(), (CharSequence[])new CharSequence[]{suffix})) {
            String serviceName = this.getGenericType(handlerType, 1).getSimpleName();
            String methodName = method.getName();
            String pathMethodName = StringUtils.replace((String)methodName, (String)suffix, (String)"");
            String path = String.format("/%s/%s/%s", suffix.replace("_", ""), serviceName, pathMethodName);
            RequestCondition condition = this.getCustomMethodCondition(method);
            RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])this.resolveEmbeddedValuesInPatterns(new String[]{path})).methods(new RequestMethod[]{RequestMethod.POST});
            if (condition != null) {
                builder.customCondition(condition);
            }
            return builder.options(this.getConfig()).build();
        }
        return super.getMappingForMethod(method, handlerType);
    }

    private Class<?> getGenericType(Class<?> handlerType, int index) {
        return (Class)((ParameterizedType)handlerType.getGenericSuperclass()).getActualTypeArguments()[index];
    }

    private RequestMappingInfo.BuilderConfiguration getConfig() {
        if (this.cacheConfig != null) {
            return this.cacheConfig;
        }
        try {
            Field field = RequestMappingHandlerMapping.class.getDeclaredField("config");
            field.setAccessible(true);
            this.cacheConfig = (RequestMappingInfo.BuilderConfiguration)field.get((Object)this);
            return this.cacheConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

