/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.DictWordInfoRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictWordInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.DictWordInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictWordInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="dictWordInfoService")
public class DictWordInfoServiceImpl
extends BaseServiceImpl<DictWordInfoDTO, DictWordInfoDO, DictWordInfoRepository>
implements DictWordInfoService {
    public List<DictWordInfoDTO> queryByCNNames(List<String> cnNames) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + cnNames.toString());
        List dictWordInfos = ((DictWordInfoRepository)this.getRepository()).queryByCNNames(cnNames);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictWordInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictWordInfos, DictWordInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int excelUpload(String type, List<DictWordInfoDTO> list) {
        int num = -1;
        if (StringUtils.equals((String)"insert", (String)type)) {
            int rs;
            String appId = null;
            String dslId = null;
            if (CollectionUtils.isNotEmpty(list)) {
                appId = list.get(0).getAppId();
                dslId = list.get(0).getDslId();
            }
            if ((rs = ((DictWordInfoRepository)this.getRepository()).deleteAll(dslId)) == -1) {
                return rs;
            }
        }
        num = this.batchInsert(list);
        return num;
    }

    public String getNewFieldCodeByCnName(String fieldName) {
        String newFieldCode = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return newFieldCode;
        }
        String currentName = fieldName;
        int strLen = fieldName.length();
        int currentIdx = strLen - 1;
        ArrayList<String> findWords = new ArrayList<String>(strLen);
        while (currentIdx > 0) {
            int currentLen = currentName.length();
            ArrayList<String> itemNames = new ArrayList<String>(currentLen);
            for (int i = 0; i < currentLen; ++i) {
                itemNames.add(StringUtils.substring((String)currentName, (int)i, (int)currentLen));
            }
            if (itemNames.isEmpty()) break;
            List list = ((DictWordInfoRepository)this.getRepository()).queryByCNNames(itemNames);
            try {
                List words = this.beansCopy(list, DictWordInfoDO.class);
                if (!CollectionUtils.isNotEmpty((Collection)words)) break;
                words.sort(new Comparator<DictWordInfoDO>(){

                    @Override
                    public int compare(DictWordInfoDO o1, DictWordInfoDO o2) {
                        return Integer.compare(o1.getWordCnDesc().length(), o2.getWordCnDesc().length()) * -1;
                    }
                });
                DictWordInfoDO word = (DictWordInfoDO)words.get(0);
                if (word.getWordCnDesc().length() == currentLen) {
                    findWords.add(word.getWordEnDesc());
                    break;
                }
                currentIdx = fieldName.lastIndexOf(word.getWordCnDesc());
                int wordIdx = currentName.lastIndexOf(word.getWordCnDesc());
                currentName = StringUtils.substring((String)currentName, (int)0, (int)wordIdx);
                findWords.add(word.getWordEnDesc());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        StringBuffer newFieldCodeBf = new StringBuffer();
        for (int i = findWords.size() - 1; i >= 0; --i) {
            newFieldCodeBf.append((String)findWords.get(i));
            if (i <= 0) continue;
            newFieldCodeBf.append("_");
        }
        newFieldCode = newFieldCodeBf.toString();
        return newFieldCode;
    }
}

