/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.acl.repository.OsrvArrangeTableRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.OsrvEvalIsrvRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.SrvModelInfoRepository;
import com.irdstudio.allinrdm.dev.console.acl.repository.SrvModelInoutRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.OsrvArrangeTableDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.OsrvEvalIsrvDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.SrvModelInfoDO;
import com.irdstudio.allinrdm.dev.console.domain.entity.SrvModelInoutDO;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalIsrvService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalIsrvDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.RowOpType;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="osrvEvalIsrvServiceImpl")
public class OsrvEvalIsrvServiceImpl
extends BaseServiceImpl<OsrvEvalIsrvDTO, OsrvEvalIsrvDO, OsrvEvalIsrvRepository>
implements OsrvEvalIsrvService {
    @Autowired
    private OsrvArrangeTableRepository osrvArrangeTableRepository;
    @Autowired
    private SrvModelInfoRepository srvModelInfoRepository;
    @Autowired
    private SrvModelInoutRepository srvModelInoutRepository;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;

    public int deleteByTableRowId(OsrvEvalIsrvDTO inOsrvEvalIsrvDTO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inOsrvEvalIsrvDTO);
        int num = 0;
        OsrvEvalIsrvDO osrvEvalIsrv = new OsrvEvalIsrvDO();
        this.beanCopy(inOsrvEvalIsrvDTO, osrvEvalIsrv);
        num = ((OsrvEvalIsrvRepository)this.getRepository()).deleteByTableRowId(osrvEvalIsrv);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inOsrvEvalIsrvDTO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public boolean refreshIsrvList(OsrvEvalIsrvDTO osrvEvalIsrvDTO) {
        String srvModelId = osrvEvalIsrvDTO.getSrvModelId();
        String tableRowId = osrvEvalIsrvDTO.getTableRowId();
        OsrvArrangeTableDO oTb = new OsrvArrangeTableDO();
        oTb.setTableRowId(tableRowId);
        oTb = (OsrvArrangeTableDO)this.osrvArrangeTableRepository.queryByPk((Object)oTb);
        if (oTb == null) {
            return false;
        }
        if (!(RowOpType.Serve.getCode().equals(oTb.getRowOpType()) || RowOpType.TServe.getCode().equals(oTb.getRowOpType()) || RowOpType.BServe.getCode().equals(oTb.getRowOpType()) || RowOpType.RServe.getCode().equals(oTb.getRowOpType()) || RowOpType.SServe.getCode().equals(oTb.getRowOpType()) || RowOpType.AssignResult.getCode().equals(oTb.getRowOpType()))) {
            return true;
        }
        String rowOpTargetId = oTb.getRowOpTargetId();
        SrvModelInfoDO infoVO = new SrvModelInfoDO();
        if (RowOpType.AssignResult.getCode().equals(oTb.getRowOpType())) {
            infoVO.setSrvModelId(srvModelId);
        } else {
            infoVO.setSrvModelId(rowOpTargetId);
        }
        infoVO = (SrvModelInfoDO)this.srvModelInfoRepository.queryByPk((Object)infoVO);
        SrvModelInoutDO inputParam = new SrvModelInoutDO();
        if (RowOpType.AssignResult.getCode().equals(oTb.getRowOpType())) {
            inputParam.setSrvModelId(srvModelId);
            inputParam.setIoType(IOType.Output.getCode());
        } else {
            inputParam.setSrvModelId(rowOpTargetId);
            inputParam.setIoType(IOType.Input.getCode());
        }
        if (StringUtils.isNotBlank((String)osrvEvalIsrvDTO.getIsrvModelId())) {
            inputParam.setTableModelId(osrvEvalIsrvDTO.getIsrvModelId());
        }
        List inputs = this.srvModelInoutRepository.querySrvInoutsWithoutParamSet(inputParam);
        int nums = 0;
        for (SrvModelInoutDO inout : inputs) {
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(inout.getTableModelId());
            List fields = this.modelTableFieldService.queryFieldWithFieldFlag(inout.getTableModelId(), infoVO.getSrvModelCatalog(), infoVO.getSrvModelType());
            ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
            tableParam.setObjectId(inout.getTableModelId());
            ModelTableInfoDTO tableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableParam);
            if (CollectionUtils.isEmpty((Collection)fields)) continue;
            ArrayList<OsrvEvalIsrvDO> vars = new ArrayList<OsrvEvalIsrvDO>(fields.size());
            for (ModelTableFieldDTO field : fields) {
                OsrvEvalIsrvDO var;
                if (!RowOpType.AssignResult.getCode().equals(oTb.getRowOpType()) && NumberUtils.toInt((String)field.getFieldFlag(), (int)0) == 0) {
                    var = new OsrvEvalIsrvDO();
                    var.setTableRowId(tableRowId);
                    var.setIsrvFieldId(field.getFieldId());
                    ((OsrvEvalIsrvRepository)this.getRepository()).deleteByTableRowId(var);
                    continue;
                }
                var = ((OsrvEvalIsrvRepository)this.getRepository()).queryByFieldId(tableRowId, field.getObjectId(), field.getFieldCode());
                if (var != null) {
                    var.setFieldOrder(field.getFieldOrder());
                    var.setIsrvFieldId(field.getFieldId());
                    var.setIsrvFieldName(field.getFieldName());
                    ((OsrvEvalIsrvRepository)this.getRepository()).updateByPk((Object)var);
                    continue;
                }
                var = new OsrvEvalIsrvDO();
                var.setRecordKeyid(UUIDUtil.getUUID());
                var.setSrvModelId(srvModelId);
                var.setTableRowId(tableRowId);
                var.setIsrvModelId(inout.getTableModelId());
                var.setIsrvModelCode(tableInfo.getObjectCode());
                var.setIsrvModelName(tableInfo.getObjectName());
                var.setIsrvFieldId(field.getFieldId());
                var.setIsrvFieldCode(field.getFieldCode());
                var.setIsrvFieldName(field.getFieldName());
                var.setFieldOrder(field.getFieldOrder());
                vars.add(var);
            }
            if (vars.isEmpty()) continue;
            nums += ((OsrvEvalIsrvRepository)this.getRepository()).batchInsert(vars);
        }
        return true;
    }
}

