/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.sam.console.application.service.utils.JGitUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TerminalExecUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocTemplateRepoPullQueueExecutor {
    private static Logger logger = LoggerFactory.getLogger(DocTemplateRepoPullQueueExecutor.class);
    private static AtomicBoolean isRunning = new AtomicBoolean(false);
    private static String docTemplatePath = null;
    private static Thread thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            isRunning.set(true);
            try {
                PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
                String userName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.doc.template.username").getParamValue();
                String password = paasEnvParamService.queryEnvParamByCodeReturnValue("git.doc.template.password").getParamValue();
                String remotePath = paasEnvParamService.queryEnvParamByCodeReturnValue("git.doc.template.remote.path").getParamValue();
                String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.doc.template.branch.name").getParamValue();
                int firstIndex = remotePath.lastIndexOf("/");
                int lastIndex = remotePath.lastIndexOf(".");
                String gitLocalPathFileName = remotePath.substring(firstIndex, lastIndex);
                String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
                boolean flag = false;
                if (gitLocalPath != null) {
                    flag = DocTemplateRepoPullQueueExecutor.repositoryCreate(gitLocalPath + gitLocalPathFileName, remotePath, userName, password, branchName);
                    if (flag) {
                        docTemplatePath = new File(gitLocalPath + gitLocalPathFileName).getAbsolutePath();
                        logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remotePath);
                    } else {
                        logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remotePath);
                    }
                    return;
                }
                return;
            }
            catch (Exception e) {
                logger.error("\u6587\u6863\u6a21\u677f\u4ed3\u5e93\u62c9\u53d6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
            }
            isRunning.set(false);
        }
    };

    public static void run() {
        if (isRunning.get()) {
            return;
        }
        DocTemplateRepoPullQueueExecutor.start();
    }

    public static synchronized void start() {
        if (isRunning.get()) {
            return;
        }
        thread.start();
    }

    public static void syncRun() {
        if (docTemplatePath != null) {
            return;
        }
        thread.run();
    }

    private static boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public static String getDocTemplatePath() {
        return docTemplatePath;
    }
}

