/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.ComBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.ComFolderInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.ComBaseInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.ComFolderInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.ComFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComFolderInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="comFolderInfoServiceImpl")
public class ComFolderInfoServiceImpl
extends BaseServiceImpl<ComFolderInfoDTO, ComFolderInfoDO, ComFolderInfoRepository>
implements ComFolderInfoService {
    @Autowired
    protected ComBaseInfoRepository comBaseInfoRepository;

    public int folderMerge(ComFolderInfoDTO paramDTO, String type) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        ComFolderInfoDTO srcPackageParam = new ComFolderInfoDTO();
        srcPackageParam.setFolderAbvId(srcPackageId);
        List subPackageList = this.queryList((BaseInfo)srcPackageParam);
        if (CollectionUtils.isNotEmpty((Collection)subPackageList)) {
            for (ComFolderInfoDTO sub : subPackageList) {
                sub.setFolderAbvId(targetFolderId);
                this.updateByPk((BaseInfo)sub);
            }
        }
        ComBaseInfoDO comFolderParam = new ComBaseInfoDO();
        comFolderParam.setFolderId(srcPackageId);
        List folderList = this.comBaseInfoRepository.queryList((Object)comFolderParam);
        if (CollectionUtils.isNotEmpty((Collection)folderList)) {
            for (ComBaseInfoDO model : folderList) {
                model.setFolderId(targetFolderId);
                model.setLastModifyUser(paramDTO.getLoginUserId());
                model.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                this.comBaseInfoRepository.updateByPk((Object)model);
            }
        }
        if (StringUtils.equals((String)type, (String)"merge")) {
            ComFolderInfoDTO deleteSrc = new ComFolderInfoDTO();
            deleteSrc.setFolderId(srcPackageId);
            this.deleteByPk((BaseInfo)deleteSrc);
        }
        return 0;
    }

    public int folderMove(ComFolderInfoDTO paramDTO) {
        if (StringUtils.isBlank((String)paramDTO.getFolderId()) || StringUtils.isBlank((String)paramDTO.getFolderAbvId())) {
            return -1;
        }
        String srcPackageId = paramDTO.getFolderId();
        String targetFolderId = paramDTO.getFolderAbvId();
        ComFolderInfoDO child = new ComFolderInfoDO();
        child.setFolderId(srcPackageId);
        child = (ComFolderInfoDO)((ComFolderInfoRepository)this.getRepository()).queryByPk((Object)child);
        if (child != null) {
            child.setFolderAbvId(targetFolderId);
            return ((ComFolderInfoRepository)this.getRepository()).updateByPk((Object)child);
        }
        return -1;
    }
}

