/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.ModelUmlNodeRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.ModelUmlNodeDO;
import com.irdstudio.allinrdm.dam.console.facade.ModelUmlNodeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelUmlNodeDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="modelUmlNodeServiceImpl")
public class ModelUmlNodeServiceImpl
extends BaseServiceImpl<ModelUmlNodeDTO, ModelUmlNodeDO, ModelUmlNodeRepository>
implements ModelUmlNodeService {
    public int deleteByCond(ModelUmlNodeDTO param) {
        ModelUmlNodeDO modelUmlNodeDO = new ModelUmlNodeDO();
        this.beanCopy(param, modelUmlNodeDO);
        return ((ModelUmlNodeRepository)this.getRepository()).deleteByCond(modelUmlNodeDO);
    }

    public int saveNodeList(String userId, List<ModelUmlNodeDTO> list) {
        int outputVo = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            String now = CurrentDateUtil.getTodayDateEx2();
            for (ModelUmlNodeDTO node : list) {
                node.setUmlNodeId(StringUtils.replace((String)node.getUmlNodeId(), (String)"-", (String)""));
                if (StringUtils.isNotBlank((CharSequence)node.getSourceNodeId())) {
                    node.setSourceNodeId(StringUtils.replace((String)node.getSourceNodeId(), (String)"-", (String)""));
                }
                if (StringUtils.isNotBlank((CharSequence)node.getTargetNodeId())) {
                    node.setTargetNodeId(StringUtils.replace((String)node.getTargetNodeId(), (String)"-", (String)""));
                }
                node.setLastUpdateUser(userId);
                node.setLastUpdateTime(now);
                int re = this.updateByPk((BaseInfo)node);
                if (re == 0) {
                    node.setCreateUser(userId);
                    node.setCreateTime(now);
                    re = this.insert((BaseInfo)node);
                }
                if (re <= 0) continue;
                ++outputVo;
            }
        }
        return outputVo;
    }
}

